/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.client.model.unbaked;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.model.ModelTemplate;
import com.sigmundgranaas.forgero.core.model.PaletteTemplateModel;
import com.sigmundgranaas.forgero.core.model.TextureModel;
import com.sigmundgranaas.forgero.core.texture.utils.Offset;
import com.sigmundgranaas.forgero.minecraft.common.client.model.unbaked.UnbakedDynamicModel;
import com.sigmundgranaas.forgero.minecraft.common.mixins.JsonUnbakedModelOverrideMixin;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import net.minecraft.class_783;
import net.minecraft.class_785;
import net.minecraft.class_793;
import net.minecraft.class_801;

public class Unbaked2DTexturedModel
implements UnbakedDynamicModel {
    public static final String TRANSPARENT_BASE_IDENTIFIER = "transparent_base";
    private static final class_801 ITEM_MODEL_GENERATOR = new class_801();
    private final List<ModelTemplate> textures;
    private final List<JsonObject> displayOverrides;
    private final Map<String, Offset> offsetMap;
    private final Map<String, Integer> resolutionMap;
    private final Map<String, Integer> indexMap;
    private final String id;
    private final class_7775 loader;
    private final Function<class_4730, class_1058> textureGetter;
    private final String parent;

    public Unbaked2DTexturedModel(class_7775 loader, Function<class_4730, class_1058> textureGetter, List<ModelTemplate> textures, String id) {
        this.loader = loader;
        this.textureGetter = textureGetter;
        this.textures = textures;
        this.id = id;
        this.offsetMap = new HashMap<String, Offset>();
        this.resolutionMap = new HashMap<String, Integer>();
        this.indexMap = new HashMap<String, Integer>();
        this.displayOverrides = new ArrayList<JsonObject>();
        this.textures.sort(Comparator.comparing(ModelTemplate::order));
        this.parent = this.textures.stream().map(ModelTemplate::getParent).flatMap(Optional::stream).findAny().orElse("minecraft:item/handheld");
    }

    private String textureName(ModelTemplate model) {
        if (model instanceof PaletteTemplateModel) {
            PaletteTemplateModel paletteTemplateModel = (PaletteTemplateModel)model;
            return this.getTextureBasePath() + String.format("%s-%s", paletteTemplateModel.palette(), paletteTemplateModel.template().replace(".png", ""));
        }
        return ((TextureModel)model).texture();
    }

    public String BuildJsonModel() {
        JsonObject model = new JsonObject();
        model.addProperty("parent", this.parent);
        model.add("textures", (JsonElement)this.getTextures());
        model.addProperty("gui_light", "front");
        if (!this.displayOverrides.isEmpty()) {
            model.add("display", (JsonElement)this.displayOverrides.get(0));
        }
        return model.toString();
    }

    protected String getTextureBasePath() {
        return "forgero:item/";
    }

    protected JsonObject getTextures() {
        JsonObject jsonTextures = new JsonObject();
        if (!this.textures.isEmpty()) {
            for (int i = 0; i < this.textures.size(); ++i) {
                String texture = this.textureName(this.textures.get(i));
                String layer = "layer" + i;
                this.offsetMap.put(layer, this.textures.get(i).getOffset().orElse(new Offset(0.0f, 0.0f)));
                this.resolutionMap.put(layer, this.textures.get(i).getResolution());
                this.textures.get(i).getDisplayOverrides().ifPresent(this.displayOverrides::add);
                this.indexMap.put(layer, i + 1);
                jsonTextures.addProperty(layer, texture);
            }
        } else {
            jsonTextures.addProperty("layer1", this.getTextureBasePath() + TRANSPARENT_BASE_IDENTIFIER);
        }
        return jsonTextures;
    }

    public class_793 buildUnbakedJsonModel() {
        return class_793.method_3430((String)this.BuildJsonModel());
    }

    public String getIdentifier() {
        return this.id;
    }

    private void applyOffset(class_785 element) {
        for (class_783 face : element.field_4230.values()) {
            Offset offset = this.offsetMap.getOrDefault(face.field_4224, new Offset(0.0f, 0.0f));
            if (offset.x() == 0.0f && offset.y() == 0.0f) continue;
            element.field_4228.add(offset.x(), offset.y(), 0.0f);
            element.field_4231.add(offset.x(), offset.y(), 0.0f);
            break;
        }
        for (class_783 face : element.field_4230.values()) {
            int index = this.indexMap.getOrDefault(face.field_4224, 1);
            if (element.field_4230.containsKey(class_2350.field_11035) || element.field_4230.containsKey(class_2350.field_11043)) {
                element.field_4228.add(0.0f, 0.0f, -0.001f * (float)index);
                element.field_4231.add(0.0f, 0.0f, 0.001f * (float)index);
            }
            if (element.field_4230.containsKey(class_2350.field_11039) || element.field_4230.containsKey(class_2350.field_11034)) {
                element.field_4228.add((float)index * 0.001f, 0.0f, 0.0f);
                element.field_4231.add((float)index * -0.001f, 0.0f, 0.0f);
            }
            if (!element.field_4230.containsKey(class_2350.field_11033) && !element.field_4230.containsKey(class_2350.field_11036)) continue;
            element.field_4228.add(0.0f, (float)index * -0.001f, 0.0f);
            element.field_4231.add(0.0f, (float)index * 0.001f, 0.0f);
        }
    }

    private void applyResolutionScaling(class_785 element) {
        Integer topResolution = this.resolutionMap.values().stream().reduce(16, Integer::max);
        if (topResolution.equals(16)) {
            return;
        }
        for (class_783 face : element.field_4230.values()) {
            Integer res = this.resolutionMap.getOrDefault(face.field_4224, 16);
            if (res.equals(topResolution)) continue;
            float initialZ = element.field_4228.z();
            float scale = (float)res.intValue() / (float)topResolution.intValue();
            element.field_4228.mul(scale, scale, 1.0f);
            element.field_4231.mul(scale, scale, 1.0f);
            float z = element.field_4228.z();
            element.field_4228.add(0.0f, 0.0f, z - initialZ);
            element.field_4231.add(0.0f, 0.0f, z - initialZ);
            break;
        }
    }

    @Override
    public class_1087 bake() {
        class_1100 parentModel = this.loader.method_45872(new class_2960(this.parent));
        class_793 model = this.buildUnbakedJsonModel();
        class_1091 id = this.getId();
        class_793 generated_model = ITEM_MODEL_GENERATOR.method_3479(this.textureGetter, model);
        for (class_785 element : generated_model.method_3433()) {
            this.applyOffset(element);
        }
        for (class_785 element : generated_model.method_3433()) {
            this.applyResolutionScaling(element);
        }
        if (parentModel instanceof class_793) {
            class_793 jsonParent = (class_793)parentModel;
            ((JsonUnbakedModelOverrideMixin)generated_model).setParent(jsonParent);
            return generated_model.method_3446(this.loader, jsonParent, this.textureGetter, (class_3665)class_1086.field_5350, (class_2960)id, true);
        }
        return generated_model.method_3446(this.loader, model, this.textureGetter, (class_3665)class_1086.field_5350, (class_2960)id, true);
    }

    @Override
    public class_1091 getId() {
        return new class_1091("forgero", this.getIdentifier(), "inventory");
    }
}

