/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.client.texture;

import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.identifier.texture.TextureIdentifier;
import com.sigmundgranaas.forgero.core.identifier.texture.toolpart.PaletteIdentifier;
import com.sigmundgranaas.forgero.core.identifier.texture.toolpart.PaletteTemplateIdentifier;
import com.sigmundgranaas.forgero.core.texture.RawTexture;
import com.sigmundgranaas.forgero.core.texture.Texture;
import com.sigmundgranaas.forgero.core.texture.TextureLoader;
import com.sigmundgranaas.forgero.minecraft.common.resources.FileService;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3298;

public class FabricTextureLoader
implements TextureLoader {
    private final Function<class_2960, Optional<class_3298>> getResource;
    private final FileService fileService;

    public FabricTextureLoader(Function<class_2960, Optional<class_3298>> getResource) {
        this.getResource = getResource;
        this.fileService = new FileService();
    }

    public Texture getResource(TextureIdentifier id) {
        try {
            if (id instanceof PaletteTemplateIdentifier) {
                return RawTexture.createRawTexture((TextureIdentifier)id, (InputStream)this.getResource.apply(new class_2960(id.getFileNameWithExtension())).get().method_14482());
            }
            return RawTexture.createRawTexture((TextureIdentifier)id, (InputStream)this.fileService.getStream(id));
        }
        catch (IOException | IllegalArgumentException | NoSuchElementException e) {
            Forgero.LOGGER.error("Unable to load {} due to {}, Falling back to default image", (Object)id.getFileNameWithExtension(), (Object)e);
            return new RawTexture(id, new BufferedImage(32, 32, 4));
        }
    }

    public Texture getResource(PaletteIdentifier id) {
        try {
            return RawTexture.createRawTexture((TextureIdentifier)id, (InputStream)this.fileService.getStream((TextureIdentifier)id));
        }
        catch (IOException e) {
            Forgero.LOGGER.error("Unable to load {} palette due to {}, Falling back to default image", (Object)id.getIdentifier(), (Object)e);
            return new RawTexture((TextureIdentifier)id, new BufferedImage(32, 32, 4));
        }
    }

    @FunctionalInterface
    public static interface Function<T, K> {
        public K apply(T var1) throws IOException;
    }
}

