/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.conversion;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.minecraft.common.conversion.Converter;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.CompoundParser;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.NbtConstants;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;

public class CachedStackConverter
implements Converter<class_1799, Optional<State>> {
    private static final Cache<class_1799, Optional<State>> stackCache = CacheBuilder.newBuilder().maximumSize(600L).expireAfterAccess(Duration.of(1L, ChronoUnit.MINUTES)).build((CacheLoader)new CacheLoader<class_1799, Optional<State>>(){

        @NotNull
        public Optional<State> load(@NotNull class_1799 key) {
            return Optional.empty();
        }
    });
    private static final LoadingCache<class_2487, Optional<State>> compoundCache = CacheBuilder.newBuilder().maximumSize(600L).expireAfterAccess(Duration.of(1L, ChronoUnit.MINUTES)).build((CacheLoader)new CacheLoader<class_2487, Optional<State>>(){

        @NotNull
        public Optional<State> load(@NotNull class_2487 key) {
            return CompoundParser.STATE_PARSER.parse(key);
        }
    });
    private final StateService stateService;

    public CachedStackConverter(StateService stateService) {
        this.stateService = stateService;
    }

    @Override
    public Optional<State> convert(class_1799 stack) {
        if (stack == null) {
            return Optional.empty();
        }
        try {
            return (Optional)stackCache.get((Object)stack, () -> this.convertCompound(stack));
        }
        catch (Exception e) {
            return this.stateService.find(stack.method_7909());
        }
    }

    public Optional<State> convertCompound(class_1799 stack) {
        try {
            if (stack.method_7985() && stack.method_7948().method_10545(NbtConstants.FORGERO_IDENTIFIER)) {
                return (Optional)compoundCache.getUnchecked((Object)stack.method_7948().method_10562(NbtConstants.FORGERO_IDENTIFIER));
            }
            return this.stateService.find(stack.method_7909());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

