/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.customdata;

import com.sigmundgranaas.forgero.core.customdata.ClassBasedVisitor;
import com.sigmundgranaas.forgero.core.customdata.DataContainer;
import com.sigmundgranaas.forgero.core.customdata.DataVisitor;
import java.util.List;
import java.util.Optional;

public class CustomNameVisitor
extends ClassBasedVisitor<NameReplacementData> {
    public static final String KEY = "name_replacement";

    private CustomNameVisitor() {
        super(NameReplacementData.class, KEY);
    }

    public static Optional<NameReplacementData> of(DataContainer dataContainer) {
        return dataContainer.accept((DataVisitor)new CustomNameVisitor());
    }

    public static List<NameReplacementData> ofAll(DataContainer dataContainer) {
        return new CustomNameVisitor().visitMultiple(dataContainer);
    }

    public static class NameReplacementData {
        private String from;
        private String to;

        public String replace(String name) {
            return name.replace(this.from, this.to);
        }

        public String from() {
            return this.from;
        }

        public String to() {
            return this.to;
        }

        public NameReplacementData from(String from) {
            this.from = from;
            return this;
        }

        public NameReplacementData to(String to) {
            this.to = to;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NameReplacementData)) {
                return false;
            }
            NameReplacementData other = (NameReplacementData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$from = this.from();
            String other$from = other.from();
            if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
                return false;
            }
            String this$to = this.to();
            String other$to = other.to();
            return !(this$to == null ? other$to != null : !this$to.equals(other$to));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NameReplacementData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $from = this.from();
            result = result * 59 + ($from == null ? 43 : $from.hashCode());
            String $to = this.to();
            result = result * 59 + ($to == null ? 43 : $to.hashCode());
            return result;
        }

        public String toString() {
            return "CustomNameVisitor.NameReplacementData(from=" + this.from() + ", to=" + this.to() + ")";
        }
    }
}

