/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.customdata;

import com.sigmundgranaas.forgero.core.customdata.ClassBasedVisitor;
import com.sigmundgranaas.forgero.core.customdata.DataContainer;
import com.sigmundgranaas.forgero.core.customdata.DataVisitor;
import com.sigmundgranaas.forgero.minecraft.common.utils.RegistryUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_7923;

public class EnchantmentVisitor
extends ClassBasedVisitor<EnchantmentData> {
    public static final String KEY = "enchantment";

    private EnchantmentVisitor() {
        super(EnchantmentData.class, KEY);
    }

    public static Optional<EnchantmentData> of(DataContainer dataContainer) {
        return dataContainer.accept((DataVisitor)new EnchantmentVisitor());
    }

    public static List<EnchantmentData> ofAll(DataContainer dataContainer) {
        return new EnchantmentVisitor().visitMultiple(dataContainer);
    }

    public static class EnchantmentData {
        private String id;
        private int level;

        public void embed(class_1799 stack) {
            RegistryUtils.safeId(this.id()).flatMap(id -> RegistryUtils.safeRegistryLookup(class_7923.field_41176, id)).filter(enchant -> enchant.method_8192(stack)).ifPresent(enchant -> stack.method_7978(enchant, this.level()));
        }

        public String id() {
            return this.id;
        }

        public int level() {
            return this.level;
        }

        public EnchantmentData id(String id) {
            this.id = id;
            return this;
        }

        public EnchantmentData level(int level) {
            this.level = level;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EnchantmentData)) {
                return false;
            }
            EnchantmentData other = (EnchantmentData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.level() != other.level()) {
                return false;
            }
            String this$id = this.id();
            String other$id = other.id();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EnchantmentData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.level();
            String $id = this.id();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        public String toString() {
            return "EnchantmentVisitor.EnchantmentData(id=" + this.id() + ", level=" + this.level() + ")";
        }
    }
}

