/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.property.v2.feature.BasePredicateData;
import com.sigmundgranaas.forgero.core.property.v2.feature.BasePredicateFeature;
import com.sigmundgranaas.forgero.core.property.v2.feature.ClassKey;
import com.sigmundgranaas.forgero.core.property.v2.feature.FeatureBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.BlockBreakHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.hardness.BlockBreakSpeedCalculator;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.hardness.Single;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.selector.BlockSelector;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_2338;

public class BlockBreakFeature
extends BasePredicateFeature
implements BlockBreakHandler {
    public static final String BLOCK_BREAK_TYPE = "minecraft:block_breaking";
    public static final ClassKey<BlockBreakFeature> KEY = new ClassKey("minecraft:block_breaking", BlockBreakFeature.class);
    public static final String SELECTOR = "selector";
    public static final String SPEED = "speed";
    public static final FeatureBuilder<BlockBreakFeature> BUILDER = FeatureBuilder.of((String)"minecraft:block_breaking", BlockBreakFeature::buildFromBase);
    private final BlockSelector selector;
    private final BlockBreakSpeedCalculator hardnessCalculator;

    public BlockBreakFeature(BasePredicateData data, BlockSelector selector, BlockBreakSpeedCalculator calculator) {
        super(data);
        this.selector = selector;
        this.hardnessCalculator = calculator;
        if (!data.type().equals(BLOCK_BREAK_TYPE)) {
            throw new IllegalArgumentException("Type needs to be: minecraft:block_breaking");
        }
    }

    private static BlockBreakFeature buildFromBase(BasePredicateData data, JsonElement element) {
        JsonObject object;
        Optional handlerOpt;
        BlockSelector selector = BlockSelector.DEFAULT;
        BlockBreakSpeedCalculator blockHardnessCalculator = Single.DEFAULT;
        if (element.isJsonObject() && element.getAsJsonObject().has(SELECTOR) && (handlerOpt = HandlerBuilder.DEFAULT.build(BlockSelector.KEY, (object = element.getAsJsonObject()).get(SELECTOR))).isPresent()) {
            selector = (BlockSelector)handlerOpt.get();
        }
        if (element.isJsonObject() && element.getAsJsonObject().has(SPEED) && (handlerOpt = HandlerBuilder.DEFAULT.build(BlockBreakSpeedCalculator.KEY, (object = element.getAsJsonObject()).get(SPEED))).isPresent()) {
            blockHardnessCalculator = (BlockBreakSpeedCalculator)handlerOpt.get();
        }
        return new BlockBreakFeature(data, selector, blockHardnessCalculator);
    }

    @Override
    public Set<class_2338> selectBlocks(class_1297 source, class_2338 target) {
        return this.selector.select(target, source);
    }

    @Override
    public float calculateBlockBreakingDelta(class_1297 source, class_2338 target, Set<class_2338> selectedBlocks) {
        return this.hardnessCalculator.calculateBlockBreakingDelta(source, target, selectedBlocks);
    }

    @Override
    public void onUsed(class_1297 source, class_2338 target, Set<class_2338> selectedBlocks) {
    }
}

