/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.feature;

import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.attribute.BaseAttribute;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttributeBuilder;
import com.sigmundgranaas.forgero.core.property.v2.cache.FeatureCache;
import com.sigmundgranaas.forgero.core.property.v2.feature.ClassKey;
import com.sigmundgranaas.forgero.core.property.v2.feature.Feature;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import com.sigmundgranaas.forgero.minecraft.common.utils.PropertyUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1799;

public class FeatureUtils {
    public static <T extends Feature> List<T> cachedRootFeatures(class_1799 stack, ClassKey<T> key) {
        Optional<State> state = StateService.INSTANCE.convert(stack);
        if (state.isEmpty() || !FeatureCache.check(key, (PropertyContainer)((PropertyContainer)state.get()))) {
            return Collections.emptyList();
        }
        return FeatureCache.getRootFeatures(key, (PropertyContainer)((PropertyContainer)state.get()));
    }

    public static <T extends Feature> List<T> appliedCachedFeatures(class_1799 stack, MatchContext context, ClassKey<T> key) {
        Optional<State> state = StateService.INSTANCE.convert(stack);
        if (state.isEmpty() || !FeatureCache.check(key, (PropertyContainer)((PropertyContainer)state.get()))) {
            return Collections.emptyList();
        }
        return FeatureCache.apply(key, (State)state.get(), (MatchContext)context);
    }

    public static <T extends Feature> List<T> cachedFilteredFeatures(class_1799 stack, ClassKey<T> key, MatchContext context) {
        return FeatureUtils.appliedCachedFeatures(stack, context, key).stream().toList();
    }

    public static <T extends Feature> Optional<T> cachedFeature(class_1799 stack, ClassKey<T> key) {
        Optional<State> state = StateService.INSTANCE.convert(stack);
        if (state.isEmpty() || !FeatureCache.check(key, (PropertyContainer)((PropertyContainer)state.get()))) {
            return Optional.empty();
        }
        return FeatureCache.getRootFeatures(key, (PropertyContainer)((PropertyContainer)state.get())).stream().findFirst();
    }

    public static <T extends Feature> Optional<T> cachedFilteredFeature(class_1799 stack, ClassKey<T> key, MatchContext context) {
        return FeatureUtils.cachedFeature(stack, key).stream().filter(feat -> feat.applyCondition(Matchable.DEFAULT_TRUE, context)).findFirst();
    }

    public static Attribute of(JsonObject value, String jsonKey, String key, float defaultValue) {
        if (value.has(jsonKey)) {
            return BaseAttribute.of((float)value.get(jsonKey).getAsFloat(), (String)key);
        }
        return BaseAttribute.of((float)defaultValue, (String)key);
    }

    public static Attribute of(JsonObject value, String jsonKey, String key, int defaultValue) {
        return FeatureUtils.of(value, jsonKey, key, (float)defaultValue);
    }

    public static ComputedAttribute compute(Attribute base, class_1297 source) {
        return ComputedAttributeBuilder.of((String)base.type()).addSource(PropertyUtils.container(source)).addSource(base).build();
    }
}

