/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.feature;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.Property;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.attribute.BaseAttribute;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import com.sigmundgranaas.forgero.core.property.v2.attribute.attributes.AttributeModification;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import net.minecraft.class_1297;
import net.minecraft.class_1657;

public class ModifiableFeatureAttribute
implements ComputedAttribute {
    private final Attribute value;

    public ModifiableFeatureAttribute(Attribute value) {
        this.value = value;
    }

    public static ModifiableFeatureAttribute of(JsonElement value, String jsonKey, String key) {
        return ModifiableFeatureAttribute.of(value.getAsJsonObject(), jsonKey, key, 1.0f);
    }

    public static ModifiableFeatureAttribute of(String key, float value) {
        return new ModifiableFeatureAttribute(BaseAttribute.of((float)value, (String)key));
    }

    public static ModifiableFeatureAttribute of(JsonObject value, String jsonKey, String key, float defaultValue) {
        if (value.has(jsonKey)) {
            return new ModifiableFeatureAttribute(BaseAttribute.of((float)value.get(jsonKey).getAsFloat(), (String)key));
        }
        return new ModifiableFeatureAttribute(BaseAttribute.of((float)defaultValue, (String)key));
    }

    public String key() {
        return this.value.type();
    }

    public Float asFloat() {
        return Float.valueOf(this.value.leveledValue());
    }

    public ModifiableFeatureAttribute with(PropertyContainer container) {
        float result = container.stream().with((Property)this.value).applyAttribute(this.key());
        return new ModifiableFeatureAttribute(BaseAttribute.of((float)result, (String)this.key()));
    }

    public ModifiableFeatureAttribute with(class_1297 entity) {
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            return this.with(player);
        }
        return this;
    }

    public ModifiableFeatureAttribute with(class_1657 entity) {
        return StateService.INSTANCE.convert(entity.method_6047()).map(this::with).orElse(this);
    }

    public ComputedAttribute modify(AttributeModification mod) {
        return this;
    }

    public static Builder builder(String attribute) {
        return new Builder(attribute);
    }

    public static class Builder {
        private String key = "value";
        private final String attribute;
        private float defaultValue;
        private boolean hasSetDefaultValue = false;

        Builder(String attribute) {
            this.attribute = attribute;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder defaultValue(float defaultValue) {
            this.defaultValue = defaultValue;
            this.hasSetDefaultValue = true;
            return this;
        }

        public ModifiableFeatureAttribute build(JsonObject object) {
            if (object.has(this.key)) {
                return ModifiableFeatureAttribute.of(this.attribute, object.get(this.key).getAsFloat());
            }
            if (!this.hasSetDefaultValue) {
                Forgero.LOGGER.warn(String.format("No key for attribute %s found in the object, and no default value set. This likely means the field was considered a mandatory field, but was not set. This is probably an error. Here is the object: \n %s", this.key, object.getAsString()));
            }
            return ModifiableFeatureAttribute.of(this.attribute, this.defaultValue);
        }
    }
}

