/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.feature;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.property.v2.feature.BasePredicateData;
import com.sigmundgranaas.forgero.core.property.v2.feature.BasePredicateFeature;
import com.sigmundgranaas.forgero.core.property.v2.feature.ClassKey;
import com.sigmundgranaas.forgero.core.property.v2.feature.FeatureBuilder;
import com.sigmundgranaas.forgero.minecraft.common.handler.HandlerBuilder;
import com.sigmundgranaas.forgero.minecraft.common.handler.afterUse.AfterUseHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.BaseHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.BlockUseHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.EntityUseHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.StopHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.UseHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;

public class OnUseFeature
extends BasePredicateFeature
implements BlockUseHandler,
EntityUseHandler,
UseHandler,
AfterUseHandler,
StopHandler {
    public static final String TYPE = "minecraft:on_use";
    public static final ClassKey<OnUseFeature> KEY = new ClassKey("minecraft:on_use", OnUseFeature.class);
    public static final String USE = "use";
    public static final String ENTIY_USE = "entity";
    public static final String BLOCK_USE = "block";
    public static final String STOP_USE = "on_stop";
    public static final String AFTER_USE = "after_use";
    public static final FeatureBuilder<OnUseFeature> BUILDER = FeatureBuilder.of((String)"minecraft:on_use", OnUseFeature::buildFromBase);
    private final List<UseHandler> onUse;
    private final List<EntityUseHandler> useOnEntity;
    private final List<BlockUseHandler> useOnBlock;
    private final List<StopHandler> onStoppedUsing;
    private final List<AfterUseHandler> afterUseHandlers;
    private final BaseHandler baseHandler;
    private final boolean usedOnRelease;
    private final class_1839 action;
    private final int maxUseTime;

    public OnUseFeature(BasePredicateData data, List<UseHandler> onUse, List<EntityUseHandler> useOnEntity, List<BlockUseHandler> useOnBlock, List<StopHandler> onStoppedUsing, List<AfterUseHandler> afterUseHandlers, BaseHandler baseHandler, boolean usedOnRelease, class_1839 action, int maxUseTime) {
        super(data);
        this.onUse = onUse;
        this.useOnEntity = useOnEntity;
        this.useOnBlock = useOnBlock;
        this.onStoppedUsing = onStoppedUsing;
        this.afterUseHandlers = afterUseHandlers;
        this.baseHandler = baseHandler;
        this.usedOnRelease = usedOnRelease;
        this.action = action;
        this.maxUseTime = maxUseTime;
        if (!data.type().equals(TYPE)) {
            throw new IllegalArgumentException("Type needs to be: minecraft:on_use");
        }
    }

    private static OnUseFeature buildFromBase(BasePredicateData data, JsonElement element) {
        List<UseHandler> use = OnUseFeature.parseHandler(UseHandler.KEY, element, USE);
        List<EntityUseHandler> entity = OnUseFeature.parseHandler(EntityUseHandler.KEY, element, ENTIY_USE);
        List<BlockUseHandler> block = OnUseFeature.parseHandler(BlockUseHandler.KEY, element, BLOCK_USE);
        List<StopHandler> stop = OnUseFeature.parseHandler(StopHandler.KEY, element, STOP_USE);
        List<AfterUseHandler> afterUseHandler = HandlerBuilder.buildHandlerFromJson(element, AFTER_USE, obj -> com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder.DEFAULT.build(AfterUseHandler.KEY, obj));
        int maxUseTime = 0;
        class_1839 action = class_1839.field_8952;
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            if (object.has("max_use_time")) {
                maxUseTime = object.get("max_use_time").getAsInt();
            }
            if (object.has("use_action")) {
                action = class_1839.valueOf((String)object.get("use_action").getAsString());
            }
        }
        BaseHandler base = Stream.of(use, entity, block, stop).flatMap(Collection::stream).map(BaseHandler.class::cast).findFirst().orElse(BaseHandler.DEFAULT);
        boolean usedOnRelease = element.isJsonObject() && element.getAsJsonObject().has("used_on_release") && element.getAsJsonObject().get("used_on_release").getAsBoolean();
        return new OnUseFeature(data, use, entity, block, stop, afterUseHandler, base, usedOnRelease, action, maxUseTime);
    }

    private static <T> List<T> parseHandler(ClassKey<T> key, JsonElement element, String jsonKey) {
        if (element.isJsonObject() && element.getAsJsonObject().has(jsonKey)) {
            JsonObject root = element.getAsJsonObject();
            if (root.get(jsonKey).isJsonObject() && element.getAsJsonObject().has(jsonKey)) {
                Optional handlerOpt = com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder.DEFAULT.build(key, root.get(jsonKey));
                return handlerOpt.map(List::of).orElse(Collections.emptyList());
            }
            if (root.get(jsonKey).isJsonArray()) {
                JsonArray elements = root.get(jsonKey).getAsJsonArray();
                ArrayList handlers = new ArrayList();
                for (JsonElement jsonElement : elements) {
                    if (!jsonElement.isJsonObject()) continue;
                    com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder.DEFAULT.build(key, (JsonElement)jsonElement.getAsJsonObject()).ifPresent(handlers::add);
                }
                if (!handlers.isEmpty()) {
                    return handlers;
                }
            }
        }
        return Collections.emptyList();
    }

    @Override
    public class_1269 useOnBlock(class_1838 context) {
        if (this.useOnBlock.isEmpty()) {
            return class_1269.field_5811;
        }
        class_1269 finalResult = class_1269.field_5811;
        for (BlockUseHandler handler : this.useOnBlock) {
            class_1269 result = handler.useOnBlock(context);
            if (result == class_1269.field_5814) {
                finalResult = result;
                break;
            }
            if (result.ordinal() >= finalResult.ordinal()) continue;
            finalResult = result;
        }
        if (finalResult != class_1269.field_5811) {
            this.afterUseHandlers.forEach(sub -> sub.handle((class_1297)context.method_8036(), context.method_8041(), context.method_20287()));
        }
        return finalResult;
    }

    @Override
    public class_1269 useOnEntity(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        if (this.useOnEntity.isEmpty()) {
            return class_1269.field_5811;
        }
        class_1269 finalResult = class_1269.field_5811;
        for (EntityUseHandler handler : this.useOnEntity) {
            class_1269 result = handler.useOnEntity(stack, user, entity, hand);
            if (result == class_1269.field_5814) {
                finalResult = result;
                break;
            }
            if (result.ordinal() >= finalResult.ordinal()) continue;
            finalResult = result;
        }
        if (finalResult != class_1269.field_5811) {
            this.afterUseHandlers.forEach(sub -> sub.handle((class_1297)user, stack, hand));
        }
        return finalResult;
    }

    @Override
    public class_1271<class_1799> onUse(class_1937 world, class_1657 user, class_1268 hand) {
        if (this.onUse.isEmpty()) {
            return class_1271.method_22430((Object)user.method_5998(hand));
        }
        class_1271<class_1799> finalResult = class_1271.method_22430((Object)user.method_5998(hand));
        for (UseHandler handler : this.onUse) {
            class_1271<class_1799> result = handler.onUse(world, user, hand);
            if (result.method_5467() == class_1269.field_5814) {
                finalResult = result;
                break;
            }
            if (result.method_5467().ordinal() >= finalResult.method_5467().ordinal()) continue;
            finalResult = result;
        }
        if (finalResult.method_5467() != class_1269.field_5811) {
            this.afterUseHandlers.forEach(sub -> sub.handle((class_1297)user, user.method_5998(hand), hand));
        }
        return finalResult;
    }

    @Override
    public void handle(class_1297 source, class_1799 target, class_1268 hand) {
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return this.action;
    }

    @Override
    public int getMaxUseTime(class_1799 stack) {
        return this.maxUseTime;
    }

    @Override
    public void usageTick(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        this.baseHandler.usageTick(world, user, stack, remainingUseTicks);
    }

    @Override
    public class_1799 finishUsing(class_1799 stack, class_1937 world, class_1309 user) {
        return this.baseHandler.finishUsing(stack, world, user);
    }

    @Override
    public void stoppedUsing(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        this.onStoppedUsing.forEach(sub -> sub.stoppedUsing(stack, world, user, remainingUseTicks));
    }

    @Override
    public boolean isUsedOnRelease(class_1799 stack) {
        return this.usedOnRelease;
    }
}

