/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.feature;

import com.google.gson.JsonElement;
import com.sigmundgranaas.forgero.core.property.v2.feature.BasePredicateData;
import com.sigmundgranaas.forgero.core.property.v2.feature.BasePredicateFeature;
import com.sigmundgranaas.forgero.core.property.v2.feature.ClassKey;
import com.sigmundgranaas.forgero.core.property.v2.feature.FeatureBuilder;
import com.sigmundgranaas.forgero.minecraft.common.handler.HandlerBuilder;
import com.sigmundgranaas.forgero.minecraft.common.handler.afterUse.AfterUseHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.swing.EntityHandHandler;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class SwingHandFeature
extends BasePredicateFeature
implements EntityHandHandler,
AfterUseHandler {
    public static final String ON_SWING_TYPE = "minecraft:on_swing";
    public static final ClassKey<SwingHandFeature> KEY = new ClassKey("minecraft:on_swing", SwingHandFeature.class);
    public static final String ON_SWING = "swing";
    public static final FeatureBuilder<SwingHandFeature> BUILDER = FeatureBuilder.of((String)"minecraft:on_swing", SwingHandFeature::buildFromBase);
    private final List<EntityHandHandler> handler;
    private final List<AfterUseHandler> afterUseHandlers;

    public SwingHandFeature(BasePredicateData data, List<EntityHandHandler> handler, List<AfterUseHandler> afterUseHandlers) {
        super(data);
        this.handler = handler;
        this.afterUseHandlers = afterUseHandlers;
        if (!data.type().equals(ON_SWING_TYPE)) {
            throw new IllegalArgumentException("Type needs to be: minecraft:on_swing");
        }
    }

    private static SwingHandFeature buildFromBase(BasePredicateData data, JsonElement element) {
        List<EntityHandHandler> handler = HandlerBuilder.buildHandlerFromJson(element, ON_SWING, obj -> com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder.DEFAULT.build(EntityHandHandler.KEY, obj));
        List<AfterUseHandler> afterUseHandler = HandlerBuilder.buildHandlerFromJson(element, "after_use", obj -> com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder.DEFAULT.build(AfterUseHandler.KEY, obj));
        return new SwingHandFeature(data, handler, afterUseHandler);
    }

    public String type() {
        return ON_SWING_TYPE;
    }

    @Override
    public void handle(class_1297 source, class_1799 target, class_1268 hand) {
        this.afterUseHandlers.forEach(sub -> sub.handle(source, target, hand));
    }

    @Override
    public void onSwing(class_1297 source, class_1268 hand) {
        this.handler.forEach(sub -> sub.onSwing(source, hand));
        if (source instanceof class_1657) {
            class_1657 playerEntity = (class_1657)source;
            this.handle(source, playerEntity.method_5998(hand), hand);
        }
    }
}

