/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.handler;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.Forgero;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class HandlerBuilder {
    public static <T> List<T> buildHandlerFromJson(JsonElement element, String key, Function<JsonElement, Optional<T>> builder) {
        ArrayList handlers = new ArrayList();
        if (element.isJsonObject() && element.getAsJsonObject().has(key)) {
            JsonElement keyElement = element.getAsJsonObject().get(key);
            if (keyElement.isJsonObject() && element.getAsJsonObject().has(key)) {
                JsonObject object = element.getAsJsonObject();
                builder.apply(object.get(key)).ifPresent(handlers::add);
            } else if (keyElement.isJsonArray()) {
                for (JsonElement arrayElement : keyElement.getAsJsonArray()) {
                    builder.apply(arrayElement).ifPresent(handlers::add);
                }
            }
        }
        if (handlers.isEmpty() && element.isJsonObject() && element.getAsJsonObject().has(key)) {
            Forgero.LOGGER.warn("Encountered empty handler from structure: {}", (Object)element);
        }
        return handlers;
    }
}

