/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.filter;

import com.google.gson.JsonElement;
import com.sigmundgranaas.forgero.core.property.v2.feature.ClassKey;
import com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import com.sigmundgranaas.forgero.core.util.TypeToken;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.filter.BlockFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_2338;

public class FilterWrapper
implements BlockFilter {
    public static String TYPE = "forgero:filter_list";
    public static ClassKey<FilterWrapper> KEY = new ClassKey(TYPE, FilterWrapper.class);
    public static JsonBuilder<FilterWrapper> BUILDER = new JsonBuilder<FilterWrapper>(){

        public Optional<FilterWrapper> build(JsonElement json) {
            if (json.isJsonArray()) {
                ArrayList<BlockFilter> filters = new ArrayList<BlockFilter>();
                json.getAsJsonArray().forEach(element -> HandlerBuilder.DEFAULT.build(BlockFilter.KEY, element).ifPresent(filters::add));
                return Optional.of(new FilterWrapper(filters));
            }
            return Optional.empty();
        }

        public TypeToken<FilterWrapper> getTargetClass() {
            return KEY.clazz();
        }
    };
    private final List<BlockFilter> filterList;

    public FilterWrapper(List<BlockFilter> filterList) {
        this.filterList = filterList;
    }

    @Override
    public boolean filter(class_1297 entity, class_2338 currentPos, class_2338 root) {
        return this.filterList.stream().allMatch(filter -> filter.filter(entity, currentPos, root));
    }
}

