/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.filter;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.property.v2.feature.ClassKey;
import com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import com.sigmundgranaas.forgero.core.util.TypeToken;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.filter.BlockFilter;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class SimilarBlockFilter
implements BlockFilter {
    public static final String TYPE = "forgero:similar_block";
    public static final SimilarBlockFilter DEFAULT = new SimilarBlockFilter();
    public static final ClassKey<SimilarBlockFilter> KEY = new ClassKey("forgero:similar_block", SimilarBlockFilter.class);
    public static final JsonBuilder<SimilarBlockFilter> BUILDER = HandlerBuilder.fromStringOrType((TypeToken)KEY.clazz(), (String)"forgero:similar_block", (Object)DEFAULT);
    private static final Cache<class_2248, Set<class_2960>> blockTagCache = CacheBuilder.newBuilder().build();
    private static final Cache<Integer, Boolean> similarityCache = CacheBuilder.newBuilder().build();
    private static Set<class_6862<class_2248>> similarBlockTags;
    private static boolean tagsLoaded;

    @Override
    public boolean filter(class_1297 entity, class_2338 currentPos, class_2338 root) {
        class_2680 currentBlock = entity.method_37908().method_8320(currentPos);
        class_2680 rootBlock = entity.method_37908().method_8320(root);
        if (currentBlock.method_26204() == rootBlock.method_26204()) {
            return true;
        }
        try {
            return (Boolean)similarityCache.get((Object)(currentBlock.method_26204().hashCode() + rootBlock.method_26204().hashCode()), () -> this.evaluateSimilarity(currentBlock, rootBlock));
        }
        catch (ExecutionException e) {
            Forgero.LOGGER.error((Object)e);
            return false;
        }
    }

    private boolean evaluateSimilarity(class_2680 currentBlock, class_2680 rootBlock) throws ExecutionException {
        if (currentBlock.method_26204().equals(rootBlock.method_26204())) {
            return true;
        }
        Set tagsCurrentBlock = (Set)blockTagCache.get((Object)currentBlock.method_26204(), () -> this.getTagsInPath(currentBlock));
        Set tagsRootBlock = (Set)blockTagCache.get((Object)rootBlock.method_26204(), () -> this.getTagsInPath(rootBlock));
        for (class_2960 tag : tagsCurrentBlock) {
            if (!tagsRootBlock.contains(tag)) continue;
            return true;
        }
        return false;
    }

    private Set<class_2960> getTagsInPath(class_2680 block) {
        this.loadSimilarBlockTags();
        return similarBlockTags.stream().filter(arg_0 -> ((class_2680)block).method_26164(arg_0)).map(class_6862::comp_327).collect(Collectors.toSet());
    }

    private void loadSimilarBlockTags() {
        if (!tagsLoaded) {
            similarBlockTags = class_7923.field_41175.method_40273().filter(key -> key.comp_327().method_12832().startsWith("similar_block")).collect(Collectors.toSet());
            tagsLoaded = true;
        }
    }

    public void onReload() {
        blockTagCache.invalidateAll();
        similarityCache.invalidateAll();
        tagsLoaded = false;
    }

    static {
        tagsLoaded = false;
    }
}

