/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.hardness;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.property.v2.feature.ClassKey;
import com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import com.sigmundgranaas.forgero.core.util.TypeToken;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.hardness.BlockBreakSpeedCalculator;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.hardness.Utils;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class Instant
implements BlockBreakSpeedCalculator {
    public static final String TYPE = "forgero:instant";
    public static final ClassKey<Instant> KEY = new ClassKey("forgero:instant", Instant.class);
    public static final JsonBuilder<Instant> BUILDER = HandlerBuilder.fromObjectOrStringDefaulted((TypeToken)KEY.clazz(), (String)"forgero:instant", Instant::fromJson, Instant::new);
    private final boolean canBreakUnmineable;

    public Instant(boolean canBreakUnmineable) {
        this.canBreakUnmineable = canBreakUnmineable;
    }

    public Instant() {
        this.canBreakUnmineable = false;
    }

    public static Instant fromJson(JsonElement jsonElement) {
        boolean canBreakUnmineable = false;
        if (jsonElement.isJsonObject()) {
            JsonObject json = jsonElement.getAsJsonObject();
            canBreakUnmineable = json.get("can_break_unmineable").getAsBoolean();
        }
        return new Instant(canBreakUnmineable);
    }

    @Override
    public float calculateBlockBreakingDelta(class_1297 source, class_2338 target, Set<class_2338> availableBlocks) {
        if (this.canBreakUnmineable) {
            return 1.0f;
        }
        class_2680 state = Utils.getStateFromWorld(source, target);
        if (state.method_26214((class_1922)source.method_37908(), target) >= 0.0f) {
            return 1.0f;
        }
        return 0.0f;
    }
}

