/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.selector;

import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import com.sigmundgranaas.forgero.minecraft.common.feature.ModifiableFeatureAttribute;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.filter.BlockFilter;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.selector.BlockSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;

public class ColumnSelector
implements BlockSelector {
    public static final String TYPE = "forgero:column";
    public static String COLUMN_MINING_DEPTH = "forgero:column_mining_depth";
    public static String DEPTH_KEY = "depth";
    public static String COLUMN_MINING_HEIGHT = "forgero:column_mining_height";
    public static String HEIGHT_KEY = "height";
    public static final ModifiableFeatureAttribute.Builder HEIGHT_BUILDER = ModifiableFeatureAttribute.builder(COLUMN_MINING_DEPTH).key(HEIGHT_KEY).defaultValue(1.0f);
    public static final ModifiableFeatureAttribute.Builder DEPTH_BUILDER = ModifiableFeatureAttribute.builder(COLUMN_MINING_HEIGHT).key(DEPTH_KEY).defaultValue(1.0f);
    public static final JsonBuilder<ColumnSelector> BUILDER = HandlerBuilder.fromObject(ColumnSelector.class, ColumnSelector::fromJson);
    private final ModifiableFeatureAttribute depth;
    private final ModifiableFeatureAttribute maxHeight;
    private final BlockFilter filter;

    public ColumnSelector(ModifiableFeatureAttribute depth, ModifiableFeatureAttribute maxHeight, BlockFilter filter) {
        this.depth = depth;
        this.maxHeight = maxHeight;
        this.filter = filter;
    }

    public static ColumnSelector fromJson(JsonObject json) {
        ModifiableFeatureAttribute depth = DEPTH_BUILDER.build(json);
        ModifiableFeatureAttribute height = HEIGHT_BUILDER.build(json);
        BlockFilter filter = (BlockFilter)HandlerBuilder.DEFAULT.build(BlockFilter.KEY, json.get("filter")).orElseThrow();
        return new ColumnSelector(depth, height, filter);
    }

    @Override
    @NotNull
    public Set<class_2338> select(class_2338 rootPos, class_1297 source) {
        if (!this.filter.filter(source, rootPos, rootPos)) {
            return new HashSet<class_2338>();
        }
        HashSet<class_2338> testedRoots = new HashSet<class_2338>();
        Predicate<class_2338> notTested = pos -> !testedRoots.contains(pos);
        HashSet<class_2338> rootsToTest = new HashSet<class_2338>();
        ArrayList<class_2338> columnRoots = new ArrayList<class_2338>();
        rootsToTest.add(rootPos);
        int depth = this.depth.with(source).asInt();
        for (int i = 0; i < depth; ++i) {
            HashSet nextRoots = new HashSet();
            if (columnRoots.size() > depth) break;
            for (class_2338 root2 : rootsToTest) {
                if (testedRoots.contains(root2)) continue;
                if (columnRoots.size() > depth) break;
                testedRoots.add(root2);
                if (!this.filter.filter(source, root2, rootPos)) continue;
                columnRoots.add(root2);
                this.horizontals(root2).filter(notTested).forEach(nextRoots::add);
            }
            rootsToTest = nextRoots;
        }
        return columnRoots.stream().map(root -> this.handleColumn((class_2338)root, source)).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }

    public Stream<class_2338> horizontals(class_2338 root) {
        return class_2350.class_2353.field_11062.method_29716().map(arg_0 -> ((class_2338)root).method_10093(arg_0));
    }

    private Set<class_2338> handleColumn(class_2338 root, class_1297 source) {
        int current;
        HashSet<class_2338> positions = new HashSet<class_2338>();
        class_2338 currentPos = root;
        int maxHeight = this.maxHeight.with(source).asInt();
        for (current = 0; this.filter.filter(source, currentPos, root) && current < maxHeight; ++current) {
            positions.add(currentPos);
            currentPos = currentPos.method_10084();
        }
        currentPos = root.method_10074();
        while (this.filter.filter(source, currentPos, root) && current < maxHeight) {
            positions.add(currentPos);
            currentPos = currentPos.method_10074();
            ++current;
        }
        return positions;
    }
}

