/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.selector;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.Forgero;
import com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import com.sigmundgranaas.forgero.minecraft.common.feature.ModifiableFeatureAttribute;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.filter.BlockFilter;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.selector.BlockSelector;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import org.jetbrains.annotations.NotNull;

public class PatternSelector
implements BlockSelector {
    public static final String TYPE = "forgero:pattern";
    public static final String DEPTH_MODIFIER = "forgero:pattern_mining_depth";
    public static final String DEPTH_MODIFIER_KEY = "depth";
    public static final ModifiableFeatureAttribute.Builder MODIFIER_BUILDER = ModifiableFeatureAttribute.builder("forgero:pattern_mining_depth").key("depth").defaultValue(1.0f);
    public static final String PATTERN_KEY = "pattern";
    public static final JsonBuilder<PatternSelector> BUILDER = HandlerBuilder.fromObject(PatternSelector.class, PatternSelector::fromJson);
    public static String multiDirection = "multi";
    public static String horizontalDirection = "horizontal";
    public static String verticalDirection = "vertical";
    private final List<String> pattern;
    private final BlockFilter filter;
    private final ModifiableFeatureAttribute depth;
    private final String direction;

    public PatternSelector(List<String> pattern, BlockFilter filter, ModifiableFeatureAttribute depth, String direction) {
        this.pattern = pattern;
        this.filter = filter;
        this.depth = depth;
        this.direction = direction;
    }

    public static PatternSelector fromJson(JsonObject json) {
        List<String> pattern = PatternSelector.parsePattern(json);
        BlockFilter filter = (BlockFilter)HandlerBuilder.DEFAULT.build(BlockFilter.KEY, json.get("filter")).orElseThrow();
        ModifiableFeatureAttribute depth = MODIFIER_BUILDER.build(json);
        String direction = json.has("direction") ? json.get("direction").getAsString() : "multi";
        return new PatternSelector(pattern, filter, depth, direction);
    }

    public static List<String> parsePattern(JsonObject object) {
        List<String> fallback = Collections.emptyList();
        Supplier<String> example = () -> "\"pattern\": [\n\"xxx\",\n\"xxx\",\n\"xxx\"\n]\n\n";
        Supplier<String> fallbackMessage = () -> "Setting an empty fallback pattern, which will not select any blocks.";
        if (!object.has(PATTERN_KEY)) {
            Forgero.LOGGER.warn("Missing pattern key for object pattern selection object. This is a required field. Here is an example of how the field can look: \n {} \n Here is the actual object: \n {}", (Object)example.get(), (Object)object);
            Forgero.LOGGER.warn(fallbackMessage.get());
            return fallback;
        }
        if (!object.get(PATTERN_KEY).isJsonArray()) {
            Forgero.LOGGER.warn("Encountered unknown pattern data: \n {}. Only lists are supported. Here is an example of a correct pattern: \n {} \n Here is the whole object: \n", (Object)object.get(PATTERN_KEY), (Object)example.get());
            Forgero.LOGGER.warn(fallbackMessage.get());
            return fallback;
        }
        return PatternSelector.stringListFromJson(object.getAsJsonArray(PATTERN_KEY));
    }

    public static List<String> stringListFromJson(JsonArray array) {
        Type typeOfList = new TypeToken<List<String>>(){}.getType();
        Gson gson = new Gson();
        return (List)gson.fromJson((JsonElement)array, typeOfList);
    }

    public Set<class_2338> selectWithDepth(class_2338 rootPos, class_1297 source) {
        HashSet<class_2338> blocks = new HashSet<class_2338>();
        class_2350 depthDirection = this.determineDepthDirection(source);
        int depthValue = this.depth.with(source).asInt();
        for (int d = 0; d < depthValue; ++d) {
            class_2338 offsetPos = rootPos.method_10079(depthDirection, d);
            blocks.addAll(this.selectPattern(offsetPos, source));
        }
        return blocks;
    }

    private class_2350 determineDepthDirection(class_1297 source) {
        boolean primaryUpOrDown;
        class_2350 primaryFacing = class_2350.method_10159((class_1297)source)[0];
        class_2350 secondaryFacing = class_2350.method_10159((class_1297)source)[1];
        boolean bl = primaryUpOrDown = primaryFacing == class_2350.field_11036 || primaryFacing == class_2350.field_11033;
        if (this.direction.equals(multiDirection)) {
            return primaryFacing != class_2350.field_11033 && primaryFacing != class_2350.field_11036 ? primaryFacing : class_2350.field_11036;
        }
        if (this.direction.equals(horizontalDirection)) {
            if (primaryUpOrDown) {
                return primaryFacing;
            }
            if (secondaryFacing == class_2350.field_11036 || secondaryFacing == class_2350.field_11033) {
                return secondaryFacing;
            }
            return class_2350.field_11033;
        }
        return primaryUpOrDown ? secondaryFacing : primaryFacing;
    }

    @Override
    @NotNull
    public Set<class_2338> select(class_2338 rootPos, class_1297 source) {
        return this.selectWithDepth(rootPos, source);
    }

    private boolean isAir(class_2338 rootPos, class_1297 source) {
        return source.method_37908().method_8320(rootPos).method_26215();
    }

    @NotNull
    public Set<class_2338> selectPattern(class_2338 rootPos, class_1297 source) {
        class_2350 facing = source.method_5735();
        class_2350[] primaryFacing = class_2350.method_10159((class_1297)source);
        HashSet<class_2338> blocks = new HashSet<class_2338>();
        for (class_2350 direction : primaryFacing) {
            if (!this.isAir(rootPos.method_10093(direction.method_10153()), source)) continue;
            facing = direction;
            break;
        }
        boolean vertical = this.direction.equals(horizontalDirection) ? false : (this.direction.equals(verticalDirection) ? true : facing != class_2350.field_11033 && facing != class_2350.field_11036);
        for (int i = 0; i < this.pattern.size(); ++i) {
            for (int j = 0; j < this.pattern.get(i).length(); ++j) {
                String slice = this.pattern.get(i);
                if (!this.isValidEntry(slice.charAt(j))) continue;
                int x = j;
                int y = i;
                int z = 0;
                class_2338 pos = new class_2338(x, y, z);
                pos = this.centerOffset().method_10059((class_2382)pos);
                if (!vertical) {
                    pos = this.rotate(pos, 1, class_2350.class_2351.field_11048);
                }
                pos = this.rotate(pos, this.rotationAmount(facing), class_2350.class_2351.field_11052);
                if (!this.filter.filter(source, pos = rootPos.method_10081((class_2382)pos), rootPos)) continue;
                blocks.add(pos);
            }
        }
        return blocks;
    }

    private class_2338 centerOffset() {
        int height = this.pattern.size();
        int width = this.pattern.get(0).length();
        int x = width / 2;
        int y = height == 2 ? 0 : height / 2;
        int z = 0;
        return new class_2338(x, y, z);
    }

    private class_2338 rotate(class_2338 pos, int times, class_2350.class_2351 axis) {
        for (int i = 0; i < times; ++i) {
            pos = this.applyRotation(pos, axis);
        }
        return pos;
    }

    private int rotationAmount(class_2350 direction) {
        int rotation = switch (direction) {
            case class_2350.field_11034 -> 1;
            case class_2350.field_11035 -> 2;
            case class_2350.field_11039 -> 3;
            default -> 0;
        };
        return rotation;
    }

    private class_2338 applyRotation(class_2338 pos, class_2350.class_2351 axis) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        switch (axis) {
            case field_11048: {
                return new class_2338(x, z, -y);
            }
            case field_11052: {
                return new class_2338(-z, y, x);
            }
            case field_11051: {
                return new class_2338(y, -x, z);
            }
        }
        return pos;
    }

    private boolean isValidEntry(char c) {
        return c == 'x' || c == 'X' || c == 'c' || c == 'C';
    }
}

