/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.selector;

import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import com.sigmundgranaas.forgero.minecraft.common.feature.ModifiableFeatureAttribute;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.filter.BlockFilter;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.selector.BlockSelector;
import com.sigmundgranaas.forgero.minecraft.common.toolhandler.block.selector.BlockSelectionUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import org.jetbrains.annotations.NotNull;

public class RadiusVeinSelector
implements BlockSelector {
    public static final String TYPE = "forgero:radius";
    public static final String VEIN_MINING_RADIUS_MODIFIER = "forgero:vein_mining_radius";
    public static final String VEIN_MINING_RADIUS_MODIFIER_KEY = "radius";
    public static final ModifiableFeatureAttribute.Builder MODIFIER_BUILDER = ModifiableFeatureAttribute.builder("forgero:vein_mining_radius").key("radius").defaultValue(1.0f);
    public static final JsonBuilder<RadiusVeinSelector> BUILDER = HandlerBuilder.fromObject(RadiusVeinSelector.class, RadiusVeinSelector::fromJson);
    private final ModifiableFeatureAttribute depth;
    private final BlockFilter filter;
    private Function<class_2338, Predicate<class_2338>> rootPosValidator = root -> blockPos -> false;

    public RadiusVeinSelector(ModifiableFeatureAttribute depth, BlockFilter filter) {
        this.depth = depth;
        this.filter = filter;
    }

    public RadiusVeinSelector(ModifiableFeatureAttribute depth, BlockFilter filter, Function<class_2338, Predicate<class_2338>> rootPosValidator) {
        this.depth = depth;
        this.filter = filter;
        this.rootPosValidator = rootPosValidator;
    }

    public static RadiusVeinSelector fromJson(JsonObject json) {
        ModifiableFeatureAttribute radius = MODIFIER_BUILDER.build(json);
        BlockFilter filter = (BlockFilter)HandlerBuilder.DEFAULT.build(BlockFilter.KEY, json.get("filter")).orElseThrow();
        return new RadiusVeinSelector(radius, filter);
    }

    @Override
    @NotNull
    public Set<class_2338> select(class_2338 rootPos, class_1297 source) {
        int depth;
        if (!this.filter.filter(source, rootPos, rootPos)) {
            return new HashSet<class_2338>();
        }
        HashSet<class_2338> selectedBlocks = new HashSet<class_2338>();
        selectedBlocks.add(rootPos);
        HashSet<Object> blocksToScan = new HashSet<Object>();
        blocksToScan.add(rootPos);
        HashSet<class_2338> scannedBlocks = new HashSet<class_2338>();
        for (int i = depth = this.depth.with(source).asInt().intValue(); i > 0 && !blocksToScan.isEmpty(); --i) {
            HashSet<class_2338> newBlocksToScan = new HashSet<class_2338>();
            for (class_2338 class_23382 : blocksToScan) {
                if (scannedBlocks.contains(class_23382)) continue;
                Set<class_2338> blocksAroundScannedBlock = BlockSelectionUtils.getBlockPositionsAround(class_23382);
                for (class_2338 pos : blocksAroundScannedBlock) {
                    if (!this.filter.filter(source, pos, rootPos)) continue;
                    selectedBlocks.add(pos);
                    newBlocksToScan.add(pos);
                }
                scannedBlocks.add(class_23382);
            }
            blocksToScan.clear();
            blocksToScan.addAll(newBlocksToScan);
        }
        return selectedBlocks;
    }

    public ModifiableFeatureAttribute depth() {
        return this.depth;
    }

    public BlockFilter filter() {
        return this.filter;
    }

    public Function<class_2338, Predicate<class_2338>> rootPosValidator() {
        return this.rootPosValidator;
    }
}

