/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.handler.entity;

import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import com.sigmundgranaas.forgero.minecraft.common.handler.entity.EntityBasedHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitBlock.BlockTargetHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitEntity.EntityTargetHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1937;

public class FrostHandler
implements EntityBasedHandler,
BlockTargetHandler,
EntityTargetHandler {
    public static final String TYPE = "minecraft:frost";
    public static final JsonBuilder<FrostHandler> BUILDER = HandlerBuilder.fromObject(FrostHandler.class, FrostHandler::fromJson);
    private final int frostTicks;
    private final String mode;

    public FrostHandler(int frostTicks, String mode) {
        this.frostTicks = frostTicks;
        this.mode = mode;
    }

    public static FrostHandler fromJson(JsonObject json) {
        int frostTicks = json.has("ticks") ? json.get("ticks").getAsInt() : 10;
        String mode = json.has("mode") ? json.get("mode").getAsString() : "add";
        return new FrostHandler(frostTicks, mode);
    }

    private void applyFrostToEntity(class_1297 entity) {
        if (this.mode().equals("add")) {
            entity.method_32317(entity.method_32312() + this.frostTicks());
        } else {
            entity.method_32317(this.frostTicks);
        }
    }

    @Override
    public void onHit(class_1297 root, class_1937 world, class_1297 target) {
        this.applyFrostToEntity(target);
    }

    @Override
    public void handle(class_1297 rootEntity) {
        this.applyFrostToEntity(rootEntity);
    }

    public int frostTicks() {
        return this.frostTicks;
    }

    public String mode() {
        return this.mode;
    }
}

