/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.handler.entity;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import com.sigmundgranaas.forgero.minecraft.common.handler.entity.EntityBasedHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitBlock.BlockTargetHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitEntity.EntityTargetHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.BlockUseHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.EntityUseHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.StopHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.UseHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2158;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_8839;

public class FunctionExecuteHandler
implements EntityTargetHandler,
EntityBasedHandler,
BlockTargetHandler,
UseHandler,
EntityUseHandler,
BlockUseHandler,
StopHandler {
    public static final String TYPE = "minecraft:function";
    public static final JsonBuilder<FunctionExecuteHandler> BUILDER = HandlerBuilder.fromObject(FunctionExecuteHandler.class, FunctionExecuteHandler::fromJson);
    private final List<SingleFunctionHandler> functions;

    private FunctionExecuteHandler(List<SingleFunctionHandler> functions) {
        this.functions = functions;
    }

    public static FunctionExecuteHandler fromJson(JsonObject json) {
        ArrayList<SingleFunctionHandler> handlers = new ArrayList<SingleFunctionHandler>();
        JsonElement element = json.get("function");
        if (element.isJsonArray()) {
            for (JsonElement item : element.getAsJsonArray()) {
                handlers.add(SingleFunctionHandler.of(item.getAsString()));
            }
        } else if (element.isJsonPrimitive()) {
            handlers.add(SingleFunctionHandler.of(element.getAsString()));
        } else {
            throw new IllegalArgumentException("Invalid format for function");
        }
        return new FunctionExecuteHandler(handlers);
    }

    @Override
    public void onHit(class_1297 source, class_1937 world, class_1297 targetEntity) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            this.execute(source, serverWorld, new class_243(targetEntity.method_23317(), targetEntity.method_23318(), targetEntity.method_23321()));
        }
    }

    private void execute(class_1297 source, class_3218 world, class_243 pos) {
        class_2168 commandSource = world.method_8503().method_3739().method_9232(source).method_9208(pos).method_9217();
        for (SingleFunctionHandler function : this.functions) {
            function.execute(world, commandSource);
        }
    }

    @Override
    public void handle(class_1297 entity) {
        this.onHit(entity, entity.method_37908(), entity);
    }

    @Override
    public void onHit(class_1297 source, class_1937 world, class_2338 pos) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            this.execute(source, serverWorld, new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()));
        }
    }

    @Override
    public class_1271<class_1799> onUse(class_1937 world, class_1657 user, class_1268 hand) {
        this.onHit((class_1297)user, world, (class_1297)user);
        return class_1271.method_22427((Object)user.method_5998(hand));
    }

    @Override
    public class_1269 useOnEntity(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        this.onHit((class_1297)user, user.method_37908(), (class_1297)entity);
        return class_1269.field_5812;
    }

    @Override
    public class_1269 useOnBlock(class_1838 context) {
        class_1937 class_19372;
        if (context.method_8045() != null && (class_19372 = context.method_8045()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            this.execute((class_1297)context.method_8036(), serverWorld, new class_243(context.method_17698().method_10216(), context.method_17698().method_10214(), context.method_17698().method_10215()));
        }
        return class_1269.field_5812;
    }

    @Override
    public void stoppedUsing(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            this.execute((class_1297)user, serverWorld, user.method_19538());
        }
    }

    public List<SingleFunctionHandler> functions() {
        return this.functions;
    }

    private static abstract class SingleFunctionHandler {
        protected final String function;

        private SingleFunctionHandler(String function) {
            this.function = function;
        }

        private static SingleFunctionHandler of(String function) {
            if (function.contains(" ")) {
                return new EmbeddedCommandHandler(function);
            }
            return new FunctionReferenceHandler(function);
        }

        abstract void execute(class_3218 var1, class_2168 var2);
    }

    private static class EmbeddedCommandHandler
    extends SingleFunctionHandler {
        private EmbeddedCommandHandler(String command) {
            super(command);
        }

        @Override
        protected void execute(class_3218 world, class_2168 source) {
            class_2158 fn = class_2158.method_9195((class_2960)new class_2960("forgero:dynamic"), (CommandDispatcher)world.method_8503().method_3740().method_12900(), (class_8839)source, List.of(this.function));
            world.method_8503().method_3740().method_12904(fn, source);
        }
    }

    private static class FunctionReferenceHandler
    extends SingleFunctionHandler {
        private FunctionReferenceHandler(String functionReference) {
            super(functionReference);
        }

        @Override
        protected void execute(class_3218 world, class_2168 source) {
            world.method_8503().method_3740().method_12905(new class_2960(this.function)).ifPresent(func -> world.method_8503().method_3740().method_12904(func, source));
        }
    }
}

