/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.handler.entity;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.attribute.BaseAttribute;
import com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import com.sigmundgranaas.forgero.minecraft.common.handler.entity.EntityBasedHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitBlock.BlockTargetHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitEntity.EntityTargetHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class MagneticHandler
implements EntityBasedHandler,
BlockTargetHandler,
EntityTargetHandler {
    public static final String TYPE = "forgero:magnetic";
    public static final String MAGNETIC_POWER_ATTRIBUTE_TYPE = "forgero:magnetic_power";
    public static final String MAGNETIC_RANGE_ATTRIBUTE_TYPE = "forgero:magnetic_range";
    public static final JsonBuilder<MagneticHandler> BUILDER = HandlerBuilder.fromObject(MagneticHandler.class, MagneticHandler::fromJson);
    private final Attribute power;
    private final Attribute distance;
    private final boolean pushAway;
    private final Set<class_1299<?>> entityFilters;

    public MagneticHandler(Attribute power, Attribute distance, Set<class_1299<?>> entityFilters, boolean pushAway) {
        this.power = power;
        this.distance = distance;
        this.entityFilters = entityFilters;
        this.pushAway = pushAway;
    }

    public static MagneticHandler fromJson(JsonObject json) {
        float power = json.has("power") ? json.get("power").getAsFloat() : 0.0f;
        float distance = json.has("range") ? json.get("range").getAsFloat() : 0.0f;
        boolean pushAway = false;
        if (json.has("pushAway")) {
            pushAway = json.get("pushAway").getAsBoolean();
        }
        HashSet entityFilters = new HashSet();
        if (json.has("filter")) {
            JsonElement filterElement = json.get("filter");
            if (filterElement.isJsonArray()) {
                for (JsonElement filter : filterElement.getAsJsonArray()) {
                    MagneticHandler.addEntityTypeFromIdentifier(entityFilters, filter.getAsString());
                }
            } else if (filterElement.isJsonPrimitive()) {
                MagneticHandler.addEntityTypeFromIdentifier(entityFilters, filterElement.getAsString());
            }
        }
        return new MagneticHandler(BaseAttribute.of((float)power, (String)MAGNETIC_POWER_ATTRIBUTE_TYPE), BaseAttribute.of((float)distance, (String)MAGNETIC_RANGE_ATTRIBUTE_TYPE), entityFilters, pushAway);
    }

    private static void addEntityTypeFromIdentifier(Set<class_1299<?>> entityFilters, String identifier) {
        class_1299 type = (class_1299)class_7923.field_41177.method_10223(class_2960.method_12829((String)identifier));
        entityFilters.add(type);
    }

    float range(class_1297 source) {
        return this.compute(this.distance, source).asFloat().floatValue();
    }

    float power(class_1297 source) {
        return this.compute(this.power, source).asFloat().floatValue();
    }

    @Override
    public void handle(class_1297 rootEntity) {
        class_243 rootVec = rootEntity.method_19538();
        float range = this.range(rootEntity);
        List<class_1297> nearbyEntities = this.getNearbyEntities(rootEntity, range, entity -> this.entityFilters.contains(entity.method_5864()));
        this.pullEntities(rootVec, nearbyEntities, rootEntity);
    }

    private List<class_1297> getNearbyEntities(class_1297 rootEntity, float range, Predicate<class_1297> predicate) {
        class_243 rootVec = rootEntity.method_19538();
        class_2338 pos1 = new class_2338((int)(rootVec.field_1352 + (double)range), (int)(rootVec.field_1351 + (double)range), (int)(rootVec.field_1350 + (double)range));
        class_2338 pos2 = new class_2338((int)(rootVec.field_1352 - (double)range), (int)(rootVec.field_1351 - (double)range), (int)(rootVec.field_1350 - (double)range));
        return rootEntity.method_37908().method_8333(rootEntity, new class_238(new class_243((double)pos1.method_10263(), (double)pos1.method_10264(), (double)pos1.method_10260()), new class_243((double)pos2.method_10263(), (double)pos2.method_10264(), (double)pos2.method_10260())), predicate);
    }

    public void pullEntities(class_243 rootVec, List<class_1297> entities, class_1297 rootEntity) {
        float computedPower = this.power(rootEntity);
        for (class_1297 nearbyEntity : entities) {
            double dist = nearbyEntity.method_19538().method_1022(rootVec);
            class_243 velocity = nearbyEntity.method_19538().method_1035(rootVec).method_1029().method_1021((double)(0.02f * computedPower));
            if (this.pushAway) {
                velocity = velocity.method_1021(-1.0);
            }
            if (dist < 1.0) {
                nearbyEntity.method_5762(0.0, 0.0, 0.0);
                continue;
            }
            nearbyEntity.method_5762(velocity.field_1352, velocity.field_1351, velocity.field_1350);
        }
    }

    @Override
    public void onHit(class_1297 root, class_1937 world, class_2338 pos) {
        this.handle(root);
    }

    @Override
    public void onHit(class_1297 root, class_1937 world, class_1297 target) {
        this.handle(root);
    }

    public Attribute power() {
        return this.power;
    }

    public Attribute distance() {
        return this.distance;
    }

    public boolean pushAway() {
        return this.pushAway;
    }

    public Set<class_1299<?>> entityFilters() {
        return this.entityFilters;
    }
}

