/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.handler.entity;

import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import com.sigmundgranaas.forgero.minecraft.common.handler.entity.EntityBasedHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitBlock.BlockTargetHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitEntity.EntityTargetHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.BlockUseHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.EntityUseHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.StopHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.UseHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ParticleHandler
implements EntityBasedHandler,
BlockTargetHandler,
EntityTargetHandler,
UseHandler,
EntityUseHandler,
BlockUseHandler,
StopHandler {
    public static final String TYPE = "minecraft:particle";
    public static final JsonBuilder<ParticleHandler> BUILDER = HandlerBuilder.fromObject(ParticleHandler.class, ParticleHandler::fromJson);
    private final class_2960 particleId;
    private final String target;
    private final int count;
    private final class_243 velocity;
    private final class_243 velocityRandomness;
    private final DirectionalBehavior behavior;
    private final class_243 offset;
    private final double spread;

    public ParticleHandler(class_2960 particleId, String target, int count, class_243 velocity, class_243 offset, class_243 velocityRandomness, DirectionalBehavior behavior, double spread) {
        this.particleId = particleId;
        this.target = target;
        this.count = count;
        this.velocity = velocity;
        this.velocityRandomness = velocityRandomness;
        this.behavior = behavior;
        this.offset = offset;
        this.spread = spread;
    }

    public static ParticleHandler fromJson(JsonObject json) {
        class_2960 particleId = new class_2960(json.get("particle").getAsString());
        int count = json.has("count") ? json.get("count").getAsInt() : 1;
        double spread = json.has("spread") ? json.get("spread").getAsDouble() : 1.0;
        String target = json.has("target") ? json.get("target").getAsString() : "target";
        class_243 offset = ParticleHandler.getVec3dFromJson(json, "offset");
        class_243 velocity = ParticleHandler.getVec3dFromJson(json, "velocity");
        class_243 velocityRandomness = ParticleHandler.getVec3dFromJson(json, "velocityRandomness");
        DirectionalBehavior behavior = DirectionalBehavior.NONE;
        if (json.has("behavior")) {
            behavior = DirectionalBehavior.valueOf(json.get("behavior").getAsString().toUpperCase());
        }
        return new ParticleHandler(particleId, target, count, velocity, offset, velocityRandomness, behavior, spread);
    }

    private static class_243 getVec3dFromJson(JsonObject jsonObject, String key) {
        if (!jsonObject.has(key)) {
            return class_243.field_1353;
        }
        JsonObject vecJson = jsonObject.getAsJsonObject(key);
        double x = vecJson.has("x") ? vecJson.get("x").getAsDouble() : 0.0;
        double y = vecJson.has("y") ? vecJson.get("y").getAsDouble() : 0.0;
        double z = vecJson.has("z") ? vecJson.get("z").getAsDouble() : 0.0;
        return new class_243(x, y, z);
    }

    private void spawnParticles(class_1297 entity, class_2338 pos) {
        this.spawnParticles(entity, new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()));
    }

    private void spawnParticles(class_1297 entity, class_243 pos) {
        class_2396 particle = (class_2396)class_7923.field_41180.method_10223(this.particleId);
        if (particle instanceof class_2400) {
            class_2400 defaultParticleType = (class_2400)particle;
            if (entity != null) {
                for (int i = 0; i < this.count; ++i) {
                    double velX = this.velocity.field_1352;
                    double velY = this.velocity.field_1351;
                    double velZ = this.velocity.field_1350;
                    if (this.behavior == DirectionalBehavior.INWARD) {
                        class_243 direction = entity.method_19538().method_1020(pos).method_1029();
                        velX *= direction.field_1352;
                        velY *= direction.field_1351;
                        velZ *= direction.field_1350;
                    } else if (this.behavior == DirectionalBehavior.OUTWARD) {
                        class_243 direction = pos.method_1020(entity.method_19538()).method_1029();
                        velX *= direction.field_1352;
                        velY *= direction.field_1351;
                        velZ *= direction.field_1350;
                    }
                    double spawnX = pos.field_1352 + (Math.random() - 0.5) * 2.0 * this.spread;
                    double spawnY = pos.field_1351 + (Math.random() - 0.5) * 2.0 * this.spread;
                    double spawnZ = pos.field_1350 + (Math.random() - 0.5) * 2.0 * this.spread;
                    entity.method_37908().method_8406((class_2394)defaultParticleType, spawnX, spawnY, spawnZ, velX += (Math.random() - 0.5) * 2.0 * this.velocityRandomness.field_1352, velY += (Math.random() - 0.5) * 2.0 * this.velocityRandomness.field_1351, velZ += (Math.random() - 0.5) * 2.0 * this.velocityRandomness.field_1350);
                }
            }
        }
    }

    @Override
    public void onHit(class_1297 root, class_1937 world, class_2338 pos) {
        if (this.target.equals("self")) {
            this.spawnParticles(root, root.method_19538());
        } else {
            this.spawnParticles(root, pos);
        }
    }

    @Override
    public void onHit(class_1297 root, class_1937 world, class_1297 target) {
        if (this.target.equals("self")) {
            this.spawnParticles(root, root.method_19538());
        } else {
            this.spawnParticles(root, target.method_19538());
        }
    }

    @Override
    public void handle(class_1297 rootEntity) {
        this.spawnParticles(rootEntity, rootEntity.method_19538());
    }

    @Override
    public class_1269 useOnBlock(class_1838 context) {
        this.spawnParticles((class_1297)context.method_8036(), context.method_17698());
        return class_1269.field_5812;
    }

    @Override
    public class_1269 useOnEntity(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        this.spawnParticles((class_1297)user, entity.method_19538());
        return class_1269.field_5812;
    }

    @Override
    public class_1271<class_1799> onUse(class_1937 world, class_1657 user, class_1268 hand) {
        this.spawnParticles((class_1297)user, user.method_19538());
        return class_1271.method_22427((Object)user.method_5998(hand));
    }

    @Override
    public void stoppedUsing(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        this.spawnParticles((class_1297)user, user.method_19538());
    }

    public class_2960 particleId() {
        return this.particleId;
    }

    public String target() {
        return this.target;
    }

    public int count() {
        return this.count;
    }

    public class_243 velocity() {
        return this.velocity;
    }

    public class_243 velocityRandomness() {
        return this.velocityRandomness;
    }

    public DirectionalBehavior behavior() {
        return this.behavior;
    }

    public class_243 offset() {
        return this.offset;
    }

    public double spread() {
        return this.spread;
    }

    public static enum DirectionalBehavior {
        NONE,
        INWARD,
        OUTWARD;

    }
}

