/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.handler.entity;

import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import com.sigmundgranaas.forgero.minecraft.common.handler.entity.EntityBasedHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitBlock.BlockTargetHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitEntity.EntityTargetHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.BlockUseHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.EntityUseHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.StopHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.UseHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;

public class SoundHandler
implements EntityBasedHandler,
BlockTargetHandler,
EntityTargetHandler,
UseHandler,
EntityUseHandler,
BlockUseHandler,
StopHandler {
    public static final String TYPE = "minecraft:play_sound";
    public static final JsonBuilder<SoundHandler> BUILDER = HandlerBuilder.fromObject(SoundHandler.class, SoundHandler::fromJson);
    private final class_2960 soundId;
    private final float volume;
    private final float pitch;

    public SoundHandler(class_2960 soundId, float volume, float pitch) {
        this.soundId = soundId;
        this.volume = volume;
        this.pitch = pitch;
    }

    public static SoundHandler fromJson(JsonObject json) {
        class_2960 soundId = new class_2960(json.get("sound").getAsString());
        float volume = json.has("volume") ? json.get("volume").getAsFloat() : 1.0f;
        float pitch = json.has("pitch") ? json.get("pitch").getAsFloat() : 1.0f;
        return new SoundHandler(soundId, volume, pitch);
    }

    @Override
    public void handle(class_1297 rootEntity) {
        this.playSound(rootEntity);
    }

    private void playSound(class_1297 entity) {
        class_3414 sound = (class_3414)class_7923.field_41172.method_10223(this.soundId);
        if (sound != null) {
            entity.method_37908().method_8396(null, entity.method_24515(), sound, class_3419.field_15254, this.volume, this.pitch);
        }
    }

    @Override
    public void onHit(class_1297 root, class_1937 world, class_2338 pos) {
        this.playSound(root);
    }

    @Override
    public void onHit(class_1297 root, class_1937 world, class_1297 target) {
        this.playSound(root);
    }

    @Override
    public class_1269 useOnBlock(class_1838 context) {
        this.playSound((class_1297)context.method_8036());
        return class_1269.field_5812;
    }

    @Override
    public class_1269 useOnEntity(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        this.playSound((class_1297)user);
        return class_1269.field_5812;
    }

    @Override
    public class_1271<class_1799> onUse(class_1937 world, class_1657 user, class_1268 hand) {
        this.playSound((class_1297)user);
        return class_1271.method_22427((Object)user.method_5998(hand));
    }

    @Override
    public void stoppedUsing(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        this.playSound((class_1297)user);
    }

    public class_2960 soundId() {
        return this.soundId;
    }

    public float volume() {
        return this.volume;
    }

    public float pitch() {
        return this.pitch;
    }
}

