/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.handler.entity;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import com.sigmundgranaas.forgero.minecraft.common.handler.entity.EntityBasedHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitBlock.BlockTargetHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitEntity.EntityTargetHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class SummonHandler
implements EntityTargetHandler,
EntityBasedHandler,
BlockTargetHandler {
    public static final String TYPE = "minecraft:summon";
    public static final JsonBuilder<SummonHandler> BUILDER = HandlerBuilder.fromObject(SummonHandler.class, SummonHandler::fromJson);
    private final String target;
    private final List<CreatureEntry> creatures;

    public SummonHandler(String target, List<CreatureEntry> creatures) {
        this.target = target;
        this.creatures = creatures;
    }

    public static SummonHandler fromJson(JsonObject json) {
        String target = json.get("target").getAsString();
        ArrayList<CreatureEntry> creatures = new ArrayList<CreatureEntry>();
        JsonArray creaturesArray = json.getAsJsonArray("creatures");
        for (JsonElement element : creaturesArray) {
            JsonObject creatureObj = element.getAsJsonObject();
            String type = creatureObj.get("type").getAsString();
            int count = creatureObj.get("count").getAsInt();
            creatures.add(new CreatureEntry(type, count));
        }
        return new SummonHandler(target, creatures);
    }

    @Override
    public void onHit(class_1297 source, class_1937 world, class_1297 targetEntity) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (this.creatures != null) {
                if ("minecraft:targeted_entity".equals(this.target)) {
                    this.execute(serverWorld, new class_243(targetEntity.method_23317() + (world.field_9229.method_43058() - 0.5) * 2.0, targetEntity.method_23318(), targetEntity.method_23321() + (world.field_9229.method_43058() - 0.5) * 2.0));
                } else {
                    this.execute(serverWorld, new class_243(source.method_23317() + (world.field_9229.method_43058() - 0.5) * 2.0, source.method_23318(), source.method_23321() + (world.field_9229.method_43058() - 0.5) * 2.0));
                }
            }
        }
    }

    public void execute(class_3218 world, class_243 pos) {
        for (CreatureEntry entry : this.creatures) {
            for (int i = 0; i < entry.count(); ++i) {
                class_1297 newEntity;
                Optional entityOpt = class_1299.method_5898((String)entry.type());
                if (!entityOpt.isPresent() || (newEntity = ((class_1299)entityOpt.get()).method_5883((class_1937)world)) == null) continue;
                newEntity.method_5808(pos.method_10216(), pos.method_10214(), pos.method_10215(), world.field_9229.method_43057() * 360.0f, 0.0f);
                world.method_8649(newEntity);
            }
        }
    }

    @Override
    public void handle(class_1297 entity) {
        this.onHit(entity, entity.method_37908(), entity);
    }

    @Override
    public void onHit(class_1297 root, class_1937 world, class_2338 pos) {
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            if (this.creatures != null) {
                if ("minecraft:targeted_entity".equals(this.target)) {
                    this.execute(serverWorld, new class_243((double)pos.method_10263() + (world.field_9229.method_43058() - 0.5) * 2.0, (double)pos.method_10264(), (double)pos.method_10260() + (world.field_9229.method_43058() - 0.5) * 2.0));
                } else {
                    this.execute(serverWorld, new class_243(root.method_23317() + (world.field_9229.method_43058() - 0.5) * 2.0, root.method_23318(), root.method_23321() + (world.field_9229.method_43058() - 0.5) * 2.0));
                }
            }
        }
    }

    public String target() {
        return this.target;
    }

    public List<CreatureEntry> creatures() {
        return this.creatures;
    }

    public static class CreatureEntry {
        private final String type;
        private final int count;

        public String type() {
            return this.type;
        }

        public int count() {
            return this.count;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreatureEntry)) {
                return false;
            }
            CreatureEntry other = (CreatureEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.count() != other.count()) {
                return false;
            }
            String this$type = this.type();
            String other$type = other.type();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CreatureEntry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.count();
            String $type = this.type();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "SummonHandler.CreatureEntry(type=" + this.type() + ", count=" + this.count() + ")";
        }

        public CreatureEntry(String type, int count) {
            this.type = type;
            this.count = count;
        }
    }
}

