/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.handler.entity;

import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import com.sigmundgranaas.forgero.minecraft.common.handler.entity.EntityBasedHandler;
import java.util.Collections;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2708;
import net.minecraft.class_3222;

public class TeleportHandler
implements EntityBasedHandler {
    public static final String TYPE = "minecraft:teleport";
    public static final JsonBuilder<TeleportHandler> BUILDER = HandlerBuilder.fromObject(TeleportHandler.class, TeleportHandler::fromJson);
    private final boolean random;
    private final boolean onGround;
    private final int maxDistance;
    private final String target;

    public TeleportHandler(boolean random, boolean onGround, int maxDistance, String target) {
        this.random = random;
        this.onGround = onGround;
        this.maxDistance = maxDistance;
        this.target = target;
    }

    public static TeleportHandler fromJson(JsonObject json) {
        boolean randomDirection = json.has("random") && json.get("random").getAsBoolean();
        boolean airTeleport = json.has("onGround") && json.get("onGround").getAsBoolean();
        int lookDirectionDistance = json.has("maxDistance") ? json.get("maxDistance").getAsInt() : 10;
        String target = json.has("target") ? json.get("target").getAsString() : "target";
        return new TeleportHandler(randomDirection, airTeleport, lookDirectionDistance, target);
    }

    @Override
    public void onHit(class_1297 source, class_1937 world, class_1297 targetEntity) {
        if (this.target.equals("target")) {
            this.teleportEntity(targetEntity, world);
        } else {
            this.teleportEntity(source, world);
        }
    }

    @Override
    public void handle(class_1297 entity) {
        this.teleportEntity(entity, entity.method_37908());
    }

    @Override
    public void onHit(class_1297 source, class_1937 world, class_2338 pos) {
    }

    private void teleportEntity(class_1297 entity, class_1937 world) {
        if (this.random) {
            this.teleportRandomly(entity, world);
        } else {
            this.teleportInLookDirection(entity, world);
        }
    }

    private void teleportRandomly(class_1297 entity, class_1937 world) {
        Random random = new Random();
        double deltaX = random.nextDouble() * 2.0 - 1.0;
        double deltaZ = random.nextDouble() * 2.0 - 1.0;
        double deltaY = !this.onGround ? random.nextDouble() * 2.0 - 1.0 : 0.0;
        class_2338 newPos = entity.method_24515().method_10069((int)(deltaX * (double)this.maxDistance), (int)(deltaY * (double)this.maxDistance), (int)(deltaZ * (double)this.maxDistance));
        this.teleportToPosition(entity, world, newPos);
    }

    private void teleportInLookDirection(class_1297 entity, class_1937 world) {
        class_243 lookVec = entity.method_5836(0.0f);
        class_2338 newPos = entity.method_24515().method_10069((int)(lookVec.field_1352 * (double)this.maxDistance), !this.onGround ? (int)(lookVec.field_1351 * (double)this.maxDistance) : 0, (int)(lookVec.field_1350 * (double)this.maxDistance));
        this.teleportToPosition(entity, world, newPos);
    }

    private boolean isSafeTeleportLocation(class_1937 world, class_2338 pos) {
        for (int yOffset = 0; yOffset <= 2; ++yOffset) {
            class_2338 checkPos = pos.method_10086(yOffset);
            if (world.method_8320(checkPos).method_45474()) continue;
            return false;
        }
        return true;
    }

    private void teleportToPosition(class_1297 entity, class_1937 world, class_2338 newPos) {
        if (this.isSafeTeleportLocation(world, newPos)) {
            entity.method_20620((double)newPos.method_10263() + 0.5, (double)newPos.method_10264(), (double)newPos.method_10260() + 0.5);
            if (entity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)entity;
                ((class_3222)entity).field_13987.method_14364((class_2596)new class_2708(entity.method_23317(), entity.method_23318(), entity.method_23321(), serverPlayer.method_36454(), serverPlayer.method_36455(), Collections.emptySet(), 0));
            }
        }
    }

    public boolean random() {
        return this.random;
    }

    public boolean onGround() {
        return this.onGround;
    }

    public int maxDistance() {
        return this.maxDistance;
    }

    public String target() {
        return this.target;
    }
}

