/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitEntity;

import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import com.sigmundgranaas.forgero.minecraft.common.feature.ModifiableFeatureAttribute;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitEntity.EntityTargetHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;

public class LifeStealHandler
implements EntityTargetHandler {
    public static final String TYPE = "forgero:life_steal";
    public static final JsonBuilder<LifeStealHandler> BUILDER = HandlerBuilder.fromObject(LifeStealHandler.class, LifeStealHandler::fromJson);
    public static final String AMOUNT_KEY = "amount";
    public static final ModifiableFeatureAttribute.Builder MODIFIER_BUILDER = ModifiableFeatureAttribute.builder("forgero:life_steal").key("amount").defaultValue(1.0f);
    private final String target;
    private final ModifiableFeatureAttribute amount;

    public LifeStealHandler(String target, ModifiableFeatureAttribute amount) {
        this.target = target;
        this.amount = amount;
    }

    public static LifeStealHandler fromJson(JsonObject json) {
        String target = json.get("target").getAsString();
        ModifiableFeatureAttribute amount = MODIFIER_BUILDER.build(json);
        return new LifeStealHandler(target, amount);
    }

    @Override
    public void onHit(class_1297 source, class_1937 world, class_1297 targetEntity) {
        if ("minecraft:targeted_entity".equals(this.target) && !world.field_9236 && targetEntity instanceof class_1309) {
            class_1309 livingTarget = (class_1309)targetEntity;
            if (source instanceof class_1309) {
                class_1309 livingSource = (class_1309)source;
                float lifeSteal = this.amount.with(targetEntity).asFloat().floatValue();
                float healthToSteal = Math.min(livingTarget.method_6032(), lifeSteal);
                livingTarget.method_5643(targetEntity.method_48923().method_48831(), healthToSteal);
                livingSource.method_6025(healthToSteal);
            }
        }
    }

    public String target() {
        return this.target;
    }

    public ModifiableFeatureAttribute amount() {
        return this.amount;
    }
}

