/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitEntity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sigmundgranaas.forgero.core.property.Attribute;
import com.sigmundgranaas.forgero.core.property.attribute.BaseAttribute;
import com.sigmundgranaas.forgero.minecraft.common.feature.FeatureUtils;
import com.sigmundgranaas.forgero.minecraft.common.handler.targeted.onHitEntity.EntityTargetHandler;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class StatusEffectHandler
implements EntityTargetHandler {
    public static final String TYPE = "minecraft:status_effect";
    public static final String EFFECT_LEVEL_ATTRIBUTE_TYPE = "minecraft:effect_level";
    public static final String EFFECT_DURATION_TYPE = "minecraft:effect_duration";
    private static final Attribute DEFAULT_LEVEL = BaseAttribute.of((int)1, (String)"minecraft:effect_level");
    private static final Attribute DEFAULT_DURATION = BaseAttribute.of((int)600, (String)"minecraft:effect_duration");
    public static Codec<class_1291> STATUS_EFFECT_CODEC = class_2960.field_25139.xmap(arg_0 -> ((class_2378)class_7923.field_41174).method_10223(arg_0), arg_0 -> ((class_2378)class_7923.field_41174).method_10221(arg_0));
    public static final Codec<StatusEffectHandler> BUILDER = StatusEffectHandler.codec();
    private final class_1291 effect;
    private final Attribute level;
    private final Attribute duration;
    private final String target;

    public StatusEffectHandler(class_1291 effect, Attribute level, Attribute duration, String target) {
        this.effect = effect;
        this.level = level;
        this.duration = duration;
        this.target = target;
    }

    public static Codec<StatusEffectHandler> codec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)STATUS_EFFECT_CODEC.fieldOf("effect").forGetter(StatusEffectHandler::effect), (App)Attribute.defaultOrExplicitTypeCodec((String)EFFECT_LEVEL_ATTRIBUTE_TYPE).optionalFieldOf("level", (Object)DEFAULT_LEVEL).forGetter(StatusEffectHandler::level), (App)Attribute.defaultOrExplicitTypeCodec((String)EFFECT_DURATION_TYPE).optionalFieldOf("duration", (Object)DEFAULT_DURATION).forGetter(StatusEffectHandler::duration), (App)Codec.STRING.fieldOf("target").forGetter(StatusEffectHandler::target)).apply((Applicative)instance, StatusEffectHandler::new));
    }

    @Override
    public void onHit(class_1297 source, class_1937 world, class_1297 targetEntity) {
        if ("minecraft:targeted_entity".equals(this.target) && targetEntity instanceof class_1309) {
            class_1309 livingTarget = (class_1309)targetEntity;
            livingTarget.method_6092(new class_1293(this.effect, this.duration(source), this.level(source) - 1));
        }
    }

    private int duration(class_1297 source) {
        return FeatureUtils.compute(this.duration, source).asInt();
    }

    private int level(class_1297 source) {
        return FeatureUtils.compute(this.level, source).asInt();
    }

    public class_1291 effect() {
        return this.effect;
    }

    public Attribute level() {
        return this.level;
    }

    public Attribute duration() {
        return this.duration;
    }

    public String target() {
        return this.target;
    }
}

