/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.handler.use;

import com.google.gson.JsonObject;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import com.sigmundgranaas.forgero.core.property.v2.feature.ClassKey;
import com.sigmundgranaas.forgero.core.property.v2.feature.HandlerBuilder;
import com.sigmundgranaas.forgero.core.property.v2.feature.JsonBuilder;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.StopHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.ThrowableItem;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

public class ThrowableHandler
implements StopHandler {
    public static final String TYPE = "forgero:throw";
    public static final ClassKey<ThrowableHandler> KEY = new ClassKey("forgero:throw", ThrowableHandler.class);
    public static final JsonBuilder<ThrowableHandler> BUILDER = HandlerBuilder.fromObject(ThrowableHandler.class, ThrowableHandler::fromJson);
    private final ThrowableConfig config;

    public ThrowableHandler(ThrowableConfig config) {
        this.config = config;
    }

    public static ThrowableHandler fromJson(JsonObject json) {
        ThrowableConfig config = ThrowableConfig.fromJson(json);
        return new ThrowableHandler(config);
    }

    @Override
    public void stoppedUsing(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (!world.field_9236) {
            float weight = StateService.INSTANCE.convert(stack).map(container -> ComputedAttribute.of((PropertyContainer)container, (String)"WEIGHT")).map(ComputedAttribute::asFloat).orElse(Float.valueOf(10.0f)).floatValue();
            ThrowableItem throwableItem = new ThrowableItem(world, user, stack.method_7972(), Float.valueOf(weight), this.config.spinType);
            throwableItem.setVelocity(user, user.method_36455(), user.method_36454(), 0.0f, 10.0f * this.config.velocityMultiplier(), this.config.instability());
            world.method_8649((class_1297)throwableItem);
        }
    }

    public record ThrowableConfig(float velocityMultiplier, float instability, ThrowableItem.SpinType spinType) {
        public static ThrowableConfig fromJson(JsonObject json) {
            float velocityMultiplier = json.has("velocity_multiplier") ? json.get("velocity_multiplier").getAsFloat() : 1.0f;
            float instability = json.has("instability") ? json.get("instability").getAsFloat() : 0.0f;
            ThrowableItem.SpinType spinType = json.has("spin_type") ? ThrowableItem.SpinType.valueOf(json.get("spin_type").getAsString()) : ThrowableItem.SpinType.NONE;
            return new ThrowableConfig(velocityMultiplier, instability, spinType);
        }
    }
}

