/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.handler.use;

import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import com.sigmundgranaas.forgero.core.property.v2.cache.ContainerTargetPair;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.minecraft.common.entity.Entities;
import com.sigmundgranaas.forgero.minecraft.common.feature.FeatureUtils;
import com.sigmundgranaas.forgero.minecraft.common.feature.OnHitBlockFeature;
import com.sigmundgranaas.forgero.minecraft.common.feature.OnHitEntityFeature;
import com.sigmundgranaas.forgero.minecraft.common.match.MinecraftContextKeys;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5819;

public class ThrowableItem
extends class_1665 {
    private static final class_2940<class_1799> STACK = class_2945.method_12791(ThrowableItem.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Float> weight = class_2945.method_12791(ThrowableItem.class, (class_2941)class_2943.field_13320);
    private static final class_2940<String> spinTypeData = class_2945.method_12791(ThrowableItem.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Boolean> hasHit = class_2945.method_12791(ThrowableItem.class, (class_2941)class_2943.field_13323);
    public static class_2960 THROWN_ENTITY_IDENTIFIER = new class_2960("forgero", "thrown_entity");

    public ThrowableItem(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world, class_1799.field_8037);
    }

    public ThrowableItem(class_1937 world, class_1309 owner, class_1799 itemStack, Float weight, SpinType spinType) {
        super(Entities.THROWN_ITEM_ENTITY, owner, world, itemStack);
        this.method_5841().method_12778(STACK, (Object)itemStack);
        this.method_5841().method_12778(spinTypeData, (Object)spinType.toString());
        this.method_5841().method_12778(ThrowableItem.weight, (Object)weight);
        this.method_5841().method_12778(hasHit, (Object)false);
    }

    protected void method_5693() {
        super.method_5693();
        this.method_5841().method_12784(STACK, (Object)class_1799.field_8037);
        this.method_5841().method_12784(weight, (Object)Float.valueOf(0.0f));
        this.method_5841().method_12784(spinTypeData, (Object)SpinType.NONE.toString());
        this.method_5841().method_12784(hasHit, (Object)false);
    }

    protected void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
        this.method_5841().method_12778(hasHit, (Object)true);
    }

    public SpinType getSpinType() {
        return SpinType.valueOf((String)this.method_5841().method_12789(spinTypeData));
    }

    public boolean isInGround() {
        return this.field_7588;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10548("weight", ((Float)this.method_5841().method_12789(weight)).floatValue());
        nbt.method_10582("spinType", (String)this.method_5841().method_12789(spinTypeData));
        if (!this.method_7445().method_7960()) {
            nbt.method_10566("Item", (class_2520)this.method_7445().method_7953(new class_2487()));
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.method_5841().method_12778(weight, (Object)Float.valueOf(nbt.method_10583("weight")));
        this.method_5841().method_12778(spinTypeData, (Object)nbt.method_10558("spinType"));
        this.method_5841().method_12778(STACK, (Object)class_1799.method_7915((class_2487)nbt.method_10562("Item")));
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        MatchContext context = MatchContext.of().put(MinecraftContextKeys.ENTITY, (Object)this.method_24921()).put(MinecraftContextKeys.WORLD, (Object)this.method_37908());
        class_2338 pos = blockHitResult.method_17777();
        FeatureUtils.cachedFilteredFeatures(this.method_7445(), OnHitBlockFeature.KEY, context.put(MinecraftContextKeys.BLOCK_TARGET, (Object)this.method_37908().method_8320(pos))).forEach(handler -> {
            handler.onHit(this.method_24921(), this.method_37908(), pos);
            handler.handle((class_1297)this, this.method_7445(), class_1268.field_5808);
        });
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1282 damageSource;
        super.method_7454(entityHitResult);
        class_1297 entity = entityHitResult.method_17782();
        MatchContext context = MatchContext.of().put(MinecraftContextKeys.ENTITY, (Object)this.method_24921()).put(MinecraftContextKeys.WORLD, (Object)this.method_37908());
        FeatureUtils.cachedFilteredFeatures(this.method_7445(), OnHitEntityFeature.KEY, context.put(MinecraftContextKeys.ENTITY_TARGET, (Object)entityHitResult.method_17782())).forEach(handler -> {
            handler.onHit(this.method_24921(), this.method_37908(), entityHitResult.method_17782());
            handler.handle((class_1297)this, this.method_7445(), class_1268.field_5808);
        });
        float damage = (float)this.getDamage(entity);
        class_1297 owner = this.method_24921();
        if (owner == null) {
            damageSource = super.method_48923().method_48803((class_1665)this, (class_1297)this);
        } else {
            damageSource = super.method_48923().method_48803((class_1665)this, owner);
            if (owner instanceof class_1309) {
                ((class_1309)owner).method_6114(entity);
            }
        }
        boolean damaged = entity.method_5643(damageSource, damage);
        if (damaged) {
            this.method_7445().method_7970(1, class_5819.method_43047(), null);
        }
        this.method_5699(this.method_7445(), 0.1f);
        this.method_31472();
    }

    protected class_1799 method_7445() {
        return (class_1799)this.method_5841().method_12789(STACK);
    }

    public double method_7448() {
        return Math.min((double)this.method_7445().method_7919() * this.method_18798().method_1033(), (double)(this.method_7445().method_7919() * 2));
    }

    public double getDamage(class_1297 target) {
        MatchContext ctx = MatchContext.of().put(MinecraftContextKeys.ENTITY_TARGET, (Object)target).put(MinecraftContextKeys.WORLD, (Object)this.method_37908());
        float damage = StateService.INSTANCE.convert(this.method_7445()).map(container -> ComputedAttribute.of((ContainerTargetPair)ContainerTargetPair.of((PropertyContainer)container, (MatchContext)ctx), (String)"ATTACK_DAMAGE")).map(ComputedAttribute::asFloat).orElse(Float.valueOf(1.0f)).floatValue();
        return Math.min((double)damage * this.method_18798().method_1033(), (double)(damage * 2.0f));
    }

    public void setVelocity(class_1309 user, float pitch, float yaw, float roll, float velocityMultiplier, float inaccuracy) {
        super.method_24919((class_1297)user, pitch, yaw, roll, velocityMultiplier / 10.0f, inaccuracy);
    }

    public static enum SpinType {
        VERTICAL,
        HORIZONTAL,
        NONE;

    }
}

