/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.item;

import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.Optional;
import net.minecraft.class_1799;

public class ArrowProperties {
    private static final float MIN_STABILITY = 0.0f;
    private static final float BASELINE_STABILITY = 20.0f;
    private static final float MIN_WEIGHT = 0.0f;
    private static final float BASELINE_WEIGHT = 3.1f;
    private final float accuracy;
    private final float weight;

    public ArrowProperties(float accuracy, float weight) {
        this.accuracy = accuracy;
        this.weight = weight;
    }

    public static ArrowProperties fromItemStack(class_1799 itemStack, StateService service) {
        Optional<State> optionalState = service.convert(itemStack);
        if (optionalState.isPresent()) {
            State state = optionalState.get();
            return new ArrowProperties(ComputedAttribute.of((PropertyContainer)state, (String)"forgero:accuracy").asFloat().floatValue(), ComputedAttribute.of((PropertyContainer)state, (String)"WEIGHT").asFloat().floatValue());
        }
        return new ArrowProperties(50.0f, 25.0f);
    }

    public float getAccuracy() {
        return this.accuracy;
    }

    public float getWeight() {
        return this.weight;
    }
}

