/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.item;

import com.sigmundgranaas.forgero.core.registry.RankableConverter;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.StateProvider;
import com.sigmundgranaas.forgero.minecraft.common.item.DefaultStateItem;
import com.sigmundgranaas.forgero.minecraft.common.item.ItemData;
import com.sigmundgranaas.forgero.minecraft.common.item.SettingProcessor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7706;

public class BuildableStateConverter
implements RankableConverter<StateProvider, ItemData> {
    private final Function<StateProvider, class_1761> group;
    private final SettingProcessor settings;
    private final Predicate<StateProvider> matcher;
    private final Function<StateProvider, class_2960> identifier;
    private final int priority;
    private final BiFunction<StateProvider, class_1792.class_1793, class_1792> item;

    public ItemData convert(StateProvider state) {
        class_1761 group = this.group.apply(state);
        class_1792.class_1793 settings = this.settings.apply(new class_1792.class_1793(), (State)state.get());
        class_1792 item = this.item.apply(state, settings);
        class_2960 id = this.identifier.apply(state);
        return new ItemData(item, id, settings, group);
    }

    public boolean matches(StateProvider state) {
        return this.matcher.test(state);
    }

    public int priority() {
        return this.priority;
    }

    private static Function<StateProvider, class_1761> $default$group() {
        return state -> (class_1761)class_7706.method_47341().get(0);
    }

    private static SettingProcessor $default$settings() {
        return (settings, state) -> settings;
    }

    private static Predicate<StateProvider> $default$matcher() {
        return state -> true;
    }

    private static Function<StateProvider, class_2960> $default$identifier() {
        return state -> new class_2960(((State)state.get()).identifier());
    }

    private static int $default$priority() {
        return 0;
    }

    private static BiFunction<StateProvider, class_1792.class_1793, class_1792> $default$item() {
        return (state, settings) -> new DefaultStateItem((class_1792.class_1793)settings, (StateProvider)state);
    }

    BuildableStateConverter(Function<StateProvider, class_1761> group, SettingProcessor settings, Predicate<StateProvider> matcher, Function<StateProvider, class_2960> identifier, int priority, BiFunction<StateProvider, class_1792.class_1793, class_1792> item) {
        this.group = group;
        this.settings = settings;
        this.matcher = matcher;
        this.identifier = identifier;
        this.priority = priority;
        this.item = item;
    }

    public static BuildableStateConverterBuilder builder() {
        return new BuildableStateConverterBuilder();
    }

    public BuildableStateConverterBuilder toBuilder() {
        return new BuildableStateConverterBuilder().group(this.group).settings(this.settings).matcher(this.matcher).identifier(this.identifier).priority(this.priority).item(this.item);
    }

    public static class BuildableStateConverterBuilder {
        private boolean group$set;
        private Function<StateProvider, class_1761> group$value;
        private boolean settings$set;
        private SettingProcessor settings$value;
        private boolean matcher$set;
        private Predicate<StateProvider> matcher$value;
        private boolean identifier$set;
        private Function<StateProvider, class_2960> identifier$value;
        private boolean priority$set;
        private int priority$value;
        private boolean item$set;
        private BiFunction<StateProvider, class_1792.class_1793, class_1792> item$value;

        BuildableStateConverterBuilder() {
        }

        public BuildableStateConverterBuilder group(Function<StateProvider, class_1761> group) {
            this.group$value = group;
            this.group$set = true;
            return this;
        }

        public BuildableStateConverterBuilder settings(SettingProcessor settings) {
            this.settings$value = settings;
            this.settings$set = true;
            return this;
        }

        public BuildableStateConverterBuilder matcher(Predicate<StateProvider> matcher) {
            this.matcher$value = matcher;
            this.matcher$set = true;
            return this;
        }

        public BuildableStateConverterBuilder identifier(Function<StateProvider, class_2960> identifier) {
            this.identifier$value = identifier;
            this.identifier$set = true;
            return this;
        }

        public BuildableStateConverterBuilder priority(int priority) {
            this.priority$value = priority;
            this.priority$set = true;
            return this;
        }

        public BuildableStateConverterBuilder item(BiFunction<StateProvider, class_1792.class_1793, class_1792> item) {
            this.item$value = item;
            this.item$set = true;
            return this;
        }

        public BuildableStateConverter build() {
            Function<StateProvider, class_1761> group$value = this.group$value;
            if (!this.group$set) {
                group$value = BuildableStateConverter.$default$group();
            }
            SettingProcessor settings$value = this.settings$value;
            if (!this.settings$set) {
                settings$value = BuildableStateConverter.$default$settings();
            }
            Predicate<StateProvider> matcher$value = this.matcher$value;
            if (!this.matcher$set) {
                matcher$value = BuildableStateConverter.$default$matcher();
            }
            Function<StateProvider, class_2960> identifier$value = this.identifier$value;
            if (!this.identifier$set) {
                identifier$value = BuildableStateConverter.$default$identifier();
            }
            int priority$value = this.priority$value;
            if (!this.priority$set) {
                priority$value = BuildableStateConverter.$default$priority();
            }
            BiFunction<StateProvider, class_1792.class_1793, class_1792> item$value = this.item$value;
            if (!this.item$set) {
                item$value = BuildableStateConverter.$default$item();
            }
            return new BuildableStateConverter(group$value, settings$value, matcher$value, identifier$value, priority$value, item$value);
        }

        public String toString() {
            return "BuildableStateConverter.BuildableStateConverterBuilder(group$value=" + this.group$value + ", settings$value=" + this.settings$value + ", matcher$value=" + this.matcher$value + ", identifier$value=" + this.identifier$value + ", priority$value=" + this.priority$value + ", item$value=" + this.item$value + ")";
        }
    }
}

