/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.item;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.sigmundgranaas.forgero.core.configuration.ForgeroConfigurationLoader;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.v2.ComputedAttribute;
import com.sigmundgranaas.forgero.core.property.v2.attribute.attributes.AttackSpeed;
import com.sigmundgranaas.forgero.core.property.v2.attribute.attributes.MiningSpeed;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.mixins.ItemUUIDMixin;
import com.sigmundgranaas.forgero.minecraft.common.registry.registrar.AttributesRegistrar;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import com.sigmundgranaas.forgero.minecraft.common.toolhandler.AdditionalHealthHandler;
import com.sigmundgranaas.forgero.minecraft.common.toolhandler.DynamicAttributeTool;
import com.sigmundgranaas.forgero.minecraft.common.toolhandler.DynamicDurability;
import com.sigmundgranaas.forgero.minecraft.common.toolhandler.DynamicEffectiveNess;
import com.sigmundgranaas.forgero.minecraft.common.toolhandler.DynamicMiningLevel;
import com.sigmundgranaas.forgero.minecraft.common.toolhandler.DynamicMiningSpeed;
import com.sigmundgranaas.forgero.minecraft.common.toolhandler.LuckHandler;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DynamicAttributeItem
extends DynamicAttributeTool,
DynamicDurability,
DynamicEffectiveNess,
DynamicMiningLevel,
DynamicMiningSpeed {
    public static final LoadingCache<class_1799, ImmutableMultimap<class_1320, class_1322>> multiMapCache = CacheBuilder.newBuilder().maximumSize(600L).expireAfterAccess(Duration.of(1L, ChronoUnit.MINUTES)).build((CacheLoader)new CacheLoader<class_1799, ImmutableMultimap<class_1320, class_1322>>(){

        @NotNull
        public ImmutableMultimap<class_1320, class_1322> load(@NotNull class_1799 stack) {
            return ImmutableMultimap.builder().build();
        }
    });
    public static final LoadingCache<class_1799, Float> miningSpeedCache = CacheBuilder.newBuilder().maximumSize(600L).expireAfterAccess(Duration.of(1L, ChronoUnit.MINUTES)).build((CacheLoader)new CacheLoader<class_1799, Float>(){

        @NotNull
        public Float load(@NotNull class_1799 stack) {
            return Float.valueOf(1.0f);
        }
    });
    public static final UUID ADDITION_HEALTH_MODIFIER_ID = UUID.randomUUID();
    public static final UUID ADDITION_LUCK_MODIFIER_ID = UUID.fromString("CC3F55D5-755C-4F38-A497-9C13A33DB5CF");
    public static final UUID ADDITION_ARMOR_MODIFIER_ID = UUID.fromString("AC3F55D5-755C-4F38-A497-9C13A63DB5CF");

    public PropertyContainer dynamicProperties(class_1799 var1);

    public PropertyContainer defaultProperties();

    default public boolean isEquippable() {
        return true;
    }

    @Override
    default public int getMiningLevel(class_1799 stack) {
        return ComputedAttribute.of((PropertyContainer)this.dynamicProperties(stack), (String)"MINING_LEVEL").asInt();
    }

    @Override
    default public int method_8024() {
        return ComputedAttribute.of((PropertyContainer)this.defaultProperties(), (String)"MINING_LEVEL").asInt();
    }

    default public boolean isCorrectMiningLevel(class_2680 state) {
        int level = this.method_8024();
        for (int i = 1; i < 10; ++i) {
            class_6862 key = class_6862.method_40092((class_5321)class_7923.field_41175.method_30517(), (class_2960)new class_2960(String.format("fabric:needs_tool_level_%s", i)));
            if (!state.method_26164(key) || level >= i) continue;
            return false;
        }
        if (state.method_26164(class_3481.field_33717) && level < 3) {
            return false;
        }
        if (state.method_26164(class_3481.field_33718) && level < 2) {
            return false;
        }
        return !state.method_26164(class_3481.field_33719) || level >= 1;
    }

    @Override
    default public Multimap<class_1320, class_1322> getDynamicModifiers(class_1304 slot, class_1799 stack, @Nullable class_1309 user) {
        if (slot.equals((Object)class_1304.field_6173) && stack.method_7909() instanceof DynamicAttributeItem && this.isEquippable()) {
            try {
                return (Multimap)multiMapCache.get((Object)stack, () -> this.createMultiMap(stack));
            }
            catch (ExecutionException e) {
                return EMPTY;
            }
        }
        return EMPTY;
    }

    private ImmutableMultimap<class_1320, class_1322> createMultiMap(class_1799 stack) {
        Matchable target = Matchable.DEFAULT_TRUE;
        MatchContext context = MatchContext.of();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        float currentToolDamage = ComputedAttribute.apply((PropertyContainer)this.dynamicProperties(stack), (String)"ATTACK_DAMAGE", (Matchable)target, (MatchContext)context).floatValue() - 1.0f;
        builder.put((Object)class_5134.field_23721, (Object)new class_1322(ItemUUIDMixin.getAttackDamageModifierID(), "Tool modifier", (double)currentToolDamage, class_1322.class_1323.field_6328));
        int luck = LuckHandler.of(this.dynamicProperties(stack)).map(ComputedAttribute::asInt).orElse(0);
        builder.put((Object)class_5134.field_23726, (Object)new class_1322(ADDITION_LUCK_MODIFIER_ID, "Luck addition", (double)luck, class_1322.class_1323.field_6328));
        float armor = ComputedAttribute.of((PropertyContainer)this.dynamicProperties(stack), (String)"ARMOR").asFloat().floatValue();
        builder.put((Object)class_5134.field_23724, (Object)new class_1322(ADDITION_ARMOR_MODIFIER_ID, "Armor addition", (double)armor, class_1322.class_1323.field_6328));
        int additionalHealth = AdditionalHealthHandler.of(this.dynamicProperties(stack)).map(ComputedAttribute::asInt).orElse(0);
        builder.put((Object)class_5134.field_23716, (Object)new class_1322(ADDITION_HEALTH_MODIFIER_ID, "Health addition", (double)additionalHealth, class_1322.class_1323.field_6328));
        float currentAttackSpeed = ComputedAttribute.apply((PropertyContainer)this.dynamicProperties(stack), (String)AttackSpeed.KEY, (Matchable)target, (MatchContext)context).floatValue();
        float baseAttackSpeed = ComputedAttribute.apply((PropertyContainer)this.defaultProperties(), (String)AttackSpeed.KEY).floatValue();
        builder.put((Object)class_5134.field_23723, (Object)new class_1322(ItemUUIDMixin.getAttackSpeedModifierID(), "Tool attack speed", (double)currentAttackSpeed, class_1322.class_1323.field_6328));
        if (ForgeroConfigurationLoader.configuration.useEntityAttributes.booleanValue()) {
            float miningSpeed = MiningSpeed.apply((PropertyContainer)this.dynamicProperties(stack)).floatValue();
            builder.put((Object)AttributesRegistrar.MINING_SPEED, (Object)new class_1322(AttributesRegistrar.BASE_MINING_SPEED_ID, "Tool modifier", (double)miningSpeed, class_1322.class_1323.field_6328));
            int durability = ComputedAttribute.of((PropertyContainer)this.dynamicProperties(stack), (String)"DURABILITY").asInt();
            builder.put((Object)AttributesRegistrar.DURABILITY, (Object)new class_1322(AttributesRegistrar.BASE_DURABILITY_ID, "Tool modifier", (double)durability, class_1322.class_1323.field_6328));
            int miningLevel = ComputedAttribute.of((PropertyContainer)this.dynamicProperties(stack), (String)"MINING_LEVEL").asInt();
            if (miningLevel != 0) {
                builder.put((Object)AttributesRegistrar.MINING_LEVEL, (Object)new class_1322(AttributesRegistrar.BASE_MINING_LEVEL_ID, "Tool modifier", (double)miningLevel, class_1322.class_1323.field_6328));
            }
        }
        return builder.build();
    }

    @Override
    default public int getDurability(class_1799 stack) {
        return ComputedAttribute.of((PropertyContainer)this.dynamicProperties(stack), (String)"DURABILITY").asInt();
    }

    default public int method_31569(class_1799 stack) {
        int durability = this.getDurability(stack);
        return durability == 0 ? 0 : Math.round(13.0f - (float)stack.method_7919() * 13.0f / (float)durability);
    }

    default public int getDurabilityColor(class_1799 stack) {
        float durability = this.getDurability(stack);
        float f = Math.max(0.0f, (durability - (float)stack.method_7919()) / durability);
        return class_3532.method_15369((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    @Override
    default public float getMiningSpeedMultiplier(class_2680 state, class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof State) {
            State dynamic = (State)class_17922;
            if (this.isEffectiveOn(state, stack)) {
                try {
                    return ((Float)miningSpeedCache.get((Object)stack, () -> Float.valueOf(this.mingSpeedCalculation((PropertyContainer)StateService.INSTANCE.convert(stack).orElse(dynamic), state)))).floatValue();
                }
                catch (ExecutionException e) {
                    return 1.0f;
                }
            }
        }
        return 1.0f;
    }

    @Override
    default public boolean isEffectiveOn(class_2680 state, class_1799 stack) {
        return this.isEffective(state, stack) && this.isCorrectMiningLevel(state, this.getMiningLevel(stack));
    }

    private float mingSpeedCalculation(PropertyContainer dynamic, class_2680 state) {
        return MiningSpeed.apply((PropertyContainer)dynamic, (Matchable)Matchable.DEFAULT_TRUE, (MatchContext)MatchContext.of()).floatValue();
    }
}

