/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.item;

import com.sigmundgranaas.forgero.core.property.v2.feature.ClassKey;
import com.sigmundgranaas.forgero.core.property.v2.feature.Feature;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.minecraft.common.feature.FeatureUtils;
import com.sigmundgranaas.forgero.minecraft.common.feature.OnUseFeature;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.BaseHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.BlockUseHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.EntityUseHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.StopHandler;
import com.sigmundgranaas.forgero.minecraft.common.handler.use.UseHandler;
import com.sigmundgranaas.forgero.minecraft.common.match.MinecraftContextKeys;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;

public interface DynamicItemUseHandler
extends EntityUseHandler,
UseHandler,
BlockUseHandler,
StopHandler {
    default public BaseHandler of(class_1799 stack, MatchContext context) {
        Optional<OnUseFeature> feature = FeatureUtils.cachedFilteredFeature(stack, OnUseFeature.KEY, context);
        if (feature.isPresent()) {
            return feature.get();
        }
        return BaseHandler.DEFAULT;
    }

    default public <T extends Feature> Optional<T> of(class_1799 stack, ClassKey<T> key, MatchContext context) {
        return FeatureUtils.cachedFilteredFeature(stack, key, context);
    }

    @Override
    default public class_1839 method_7853(class_1799 stack) {
        return this.dynamicGetUseAction(stack);
    }

    @Override
    default public int getMaxUseTime(class_1799 stack) {
        return this.dynamicGetMaxUseTime(stack);
    }

    @Override
    default public void usageTick(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        this.dynamicUsageTick(world, user, stack, remainingUseTicks);
    }

    @Override
    default public class_1799 finishUsing(class_1799 stack, class_1937 world, class_1309 user) {
        return this.dynamicFinishUsing(stack, world, user);
    }

    @Override
    default public void stoppedUsing(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        this.dynamicOnStoppedUsing(stack, world, user, remainingUseTicks);
    }

    @Override
    default public boolean isUsedOnRelease(class_1799 stack) {
        return this.dynamicIsUsedOnRelease(stack);
    }

    @Override
    default public class_1269 useOnBlock(class_1838 context) {
        return this.dynamicUseOnBlock(context);
    }

    @Override
    default public class_1269 useOnEntity(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        return this.dynamicUseOnEntity(stack, user, entity, hand);
    }

    @Override
    default public class_1271<class_1799> onUse(class_1937 world, class_1657 user, class_1268 hand) {
        return this.dynamicUse(world, user, hand);
    }

    default public class_1839 dynamicGetUseAction(class_1799 stack) {
        return this.of(stack, MatchContext.of().put(MinecraftContextKeys.STACK, (Object)stack)).method_7853(stack);
    }

    default public int dynamicGetMaxUseTime(class_1799 stack) {
        return this.of(stack, MatchContext.of().put(MinecraftContextKeys.STACK, (Object)stack)).getMaxUseTime(stack);
    }

    default public void dynamicUsageTick(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        this.of(stack, MatchContext.of().put(MinecraftContextKeys.STACK, (Object)stack).put(MinecraftContextKeys.WORLD, (Object)world).put(MinecraftContextKeys.ENTITY, (Object)user)).usageTick(world, user, stack, remainingUseTicks);
    }

    default public class_1799 dynamicFinishUsing(class_1799 stack, class_1937 world, class_1309 user) {
        return this.of(stack, MatchContext.of().put(MinecraftContextKeys.STACK, (Object)stack).put(MinecraftContextKeys.WORLD, (Object)world).put(MinecraftContextKeys.ENTITY, (Object)user)).finishUsing(stack, world, user);
    }

    default public void dynamicOnStoppedUsing(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        this.of(stack, OnUseFeature.KEY, MatchContext.of().put(MinecraftContextKeys.STACK, (Object)stack).put(MinecraftContextKeys.WORLD, (Object)world).put(MinecraftContextKeys.ENTITY, (Object)user)).ifPresent(handler -> handler.stoppedUsing(stack, world, user, remainingUseTicks));
    }

    default public boolean dynamicIsUsedOnRelease(class_1799 stack) {
        return this.of(stack, MatchContext.of().put(MinecraftContextKeys.STACK, (Object)stack)).isUsedOnRelease(stack);
    }

    default public class_1269 dynamicUseOnBlock(class_1838 context) {
        return this.of(context.method_8041(), OnUseFeature.KEY, MatchContext.of().put(MinecraftContextKeys.ENTITY, (Object)context.method_8036()).put(MinecraftContextKeys.WORLD, (Object)Objects.requireNonNull(context.method_8036()).method_37908()).put(MinecraftContextKeys.BLOCK_TARGET, (Object)context.method_8037())).map(handler -> handler.useOnBlock(context)).orElse(class_1269.field_5811);
    }

    default public class_1269 dynamicUseOnEntity(class_1799 stack, class_1657 user, class_1309 entity, class_1268 hand) {
        return this.of(stack, OnUseFeature.KEY, MatchContext.of().put(MinecraftContextKeys.STACK, (Object)stack).put(MinecraftContextKeys.WORLD, (Object)user.method_37908()).put(MinecraftContextKeys.ENTITY, (Object)user)).map(handler -> handler.useOnEntity(stack, user, entity, hand)).orElse(class_1269.field_5811);
    }

    default public class_1271<class_1799> dynamicUse(class_1937 world, class_1657 user, class_1268 hand) {
        return this.of(user.method_5998(hand), OnUseFeature.KEY, MatchContext.of().put(MinecraftContextKeys.STACK, (Object)user.method_5998(hand)).put(MinecraftContextKeys.WORLD, (Object)world).put(MinecraftContextKeys.ENTITY, (Object)user)).map(handler -> handler.onUse(world, user, hand)).orElse(class_1271.method_22430((Object)user.method_5998(hand)));
    }
}

