/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.item;

import com.sigmundgranaas.forgero.core.registry.BuildableGenericConverter;
import com.sigmundgranaas.forgero.core.registry.GenericRegistry;
import com.sigmundgranaas.forgero.core.registry.RankableConverter;
import com.sigmundgranaas.forgero.core.registry.Registerable;
import com.sigmundgranaas.forgero.core.state.MaterialBased;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.StateProvider;
import com.sigmundgranaas.forgero.core.state.composite.ConstructedTool;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.item.DefaultStateItem;
import com.sigmundgranaas.forgero.minecraft.common.item.SettingProcessor;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1834;
import net.minecraft.class_1856;
import org.apache.commons.lang3.function.TriFunction;

public class RegistryUtils {
    public static final BiFunction<StateProvider, class_1792.class_1793, class_1792> defaultItem = (state, settings) -> new DefaultStateItem((class_1792.class_1793)settings, (StateProvider)state);

    public static <T> void register(GenericRegistry<T> registry, Supplier<Registerable<T>> entry) {
        entry.get().register(registry);
    }

    public static <T> void register(GenericRegistry<T> registry, Registerable<T> entry) {
        entry.register(registry);
    }

    public static BiFunction<StateProvider, class_1792.class_1793, class_1792> itemClassPreparer(TriFunction<StateProvider, class_1792.class_1793, DynamicToolItemSettings, class_1792> converter) {
        return (state, settings) -> RegistryUtils.dynamicTool(converter, state, settings);
    }

    public static SettingProcessor settingProcessor(GenericRegistry<SettingProcessor> registry) {
        return (settings, state) -> {
            registry.values().forEach(processor -> processor.apply(settings, state));
            return settings;
        };
    }

    public static class_1792 dynamicTool(TriFunction<StateProvider, class_1792.class_1793, DynamicToolItemSettings, class_1792> converter, StateProvider provider, class_1792.class_1793 settings) {
        DynamicToolItemSettings params = RegistryUtils.createDynamicSettings(provider);
        return (class_1792)converter.apply((Object)provider, (Object)settings, (Object)params);
    }

    public static Predicate<StateProvider> typeMatcher(Type type) {
        return state -> ((State)state.get()).type().test((Matchable)type);
    }

    public static Predicate<StateProvider> typeMatcher(String type) {
        return state -> ((State)state.get()).type().test((Matchable)Type.of((String)type));
    }

    public static class_1856 createIngredientFromState(StateProvider provider) {
        ConstructedTool tool;
        State state;
        State state2 = (State)provider.get();
        Optional<State> ingredientState = Optional.empty();
        if (state2 instanceof ConstructedTool && (state = (tool = (ConstructedTool)state2).getHead()) instanceof MaterialBased) {
            MaterialBased based = (MaterialBased)state;
            ingredientState = Optional.of(based.baseMaterial());
        }
        StateService service = StateService.INSTANCE;
        return ingredientState.flatMap(service::convert).map(xva$0 -> class_1856.method_8101((class_1799[])new class_1799[]{xva$0})).orElse(class_1834.field_8922.method_8023());
    }

    public static DynamicToolItemSettings createDynamicSettings(StateProvider provider) {
        State state = (State)provider.get();
        int attackDamage = (int)state.stream().applyAttribute("ATTACK_DAMAGE");
        float attackSpeed = state.stream().applyAttribute("ATTACK_DAMAGE");
        class_1856 ingredient = RegistryUtils.createIngredientFromState(provider);
        return new DynamicToolItemSettings(attackDamage, attackSpeed, ingredient);
    }

    public static RankableConverter<StateProvider, class_1761> typeConverter(Type type, class_1761 group) {
        return RegistryUtils.typeConverter(type, group, 1);
    }

    public static RankableConverter<StateProvider, class_1761> typeConverter(Type type, class_1761 group, int priority) {
        return BuildableGenericConverter.builder().matcher(state -> ((State)state.get()).test((Matchable)type)).priority(priority).converter(state -> group).build();
    }

    public record DynamicToolItemSettings(int attackDamage, float attackSpeed, class_1856 ingredient) {
    }
}

