/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2;

import com.sigmundgranaas.forgero.core.condition.Conditional;
import com.sigmundgranaas.forgero.core.soul.SoulContainer;
import com.sigmundgranaas.forgero.core.state.Identifiable;
import com.sigmundgranaas.forgero.core.state.Slot;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.Upgradeable;
import com.sigmundgranaas.forgero.core.state.composite.Constructed;
import com.sigmundgranaas.forgero.core.state.composite.ConstructedSchematicPart;
import com.sigmundgranaas.forgero.core.state.composite.ConstructedTool;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.CompoundEncoder;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.IdentifiableEncoder;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.NbtConstants;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.SlotEncoder;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.SoulEncoder;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.StateEncoder;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class CompositeEncoder
implements CompoundEncoder<State> {
    private final IdentifiableEncoder identifiableEncoder;
    private final SlotEncoder slotEncoder;
    private final StateEncoder stateEncoder = new StateEncoder();

    public CompositeEncoder() {
        this.identifiableEncoder = new IdentifiableEncoder();
        this.slotEncoder = new SlotEncoder(this.stateEncoder);
    }

    public static class_2499 encodeConditions(Conditional<?> conditional) {
        class_2499 list = new class_2499();
        conditional.namedConditions(conditional.localConditions()).stream().map(Identifiable::identifier).map(class_2519::method_23256).forEach(arg_0 -> list.add(arg_0));
        return list;
    }

    @Override
    public class_2487 encode(State element) {
        Constructed constructed;
        class_2487 compound = this.identifiableEncoder.encode((Identifiable)element);
        compound.method_10582(NbtConstants.STATE_TYPE_IDENTIFIER, NbtConstants.COMPOSITE_IDENTIFIER);
        compound.method_10582(NbtConstants.TYPE_IDENTIFIER, element.type().typeName());
        if (element instanceof SoulContainer) {
            SoulContainer soulContainer = (SoulContainer)element;
            compound.method_10566(NbtConstants.SOUL_IDENTIFIER, (class_2520)SoulEncoder.ENCODER.encode(soulContainer.getSoul()));
        }
        if (element instanceof ConstructedTool || element instanceof Constructed && ConstructedTool.ToolBuilder.builder((List)(constructed = (Constructed)element).parts()).isPresent()) {
            compound.method_10582(NbtConstants.COMPOSITE_TYPE, NbtConstants.TOOL_IDENTIFIER);
        }
        if (element instanceof ConstructedSchematicPart || element instanceof Constructed && ConstructedSchematicPart.SchematicPartBuilder.builder((List)(constructed = (Constructed)element).parts()).isPresent()) {
            compound.method_10582(NbtConstants.COMPOSITE_TYPE, NbtConstants.SCHEMATIC_PART_IDENTIFIER);
        }
        if (element instanceof Conditional) {
            Conditional conditional = (Conditional)element;
            compound.method_10566(NbtConstants.CONDITIONS_IDENTIFIER, (class_2520)CompositeEncoder.encodeConditions(conditional));
        }
        if (element instanceof Constructed) {
            constructed = (Constructed)element;
            class_2499 ingredients = new class_2499();
            constructed.parts().stream().map(this.stateEncoder::encode).forEach(arg_0 -> ingredients.add(arg_0));
            compound.method_10566(NbtConstants.INGREDIENTS_IDENTIFIER, (class_2520)ingredients);
        }
        if (element instanceof Upgradeable) {
            Upgradeable upgradeable = (Upgradeable)element;
            class_2499 upgrades = new class_2499();
            upgradeable.slots().forEach(upgrade -> {
                class_2487 upgradeCompound = this.slotEncoder.encode((Slot)upgrade);
                upgrades.add((Object)upgradeCompound);
            });
            compound.method_10566(NbtConstants.UPGRADES_IDENTIFIER, (class_2520)upgrades);
        }
        return compound;
    }
}

