/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2;

import com.sigmundgranaas.forgero.core.registry.StateFinder;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.CompoundParser;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.ConstructParser;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.NbtConstants;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.SchematicPartParser;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.StateParser;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.ToolParser;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class CompositeParser
implements CompoundParser<State> {
    protected final StateFinder supplier;

    public CompositeParser(StateFinder supplier) {
        this.supplier = supplier;
    }

    @Override
    public Optional<State> parse(class_2487 compound) {
        if (!compound.method_10545(NbtConstants.STATE_TYPE_IDENTIFIER)) {
            return Optional.empty();
        }
        Optional<State> tool = new ToolParser(this.supplier).parse(compound);
        if (tool.isPresent()) {
            return tool;
        }
        Optional<State> part = new SchematicPartParser(this.supplier).parse(compound);
        if (part.isPresent()) {
            return part;
        }
        return new ConstructParser(this.supplier).parse(compound);
    }

    public void parseParts(Consumer<State> partConsumer, class_2487 compound) {
        if (compound.method_10545(NbtConstants.INGREDIENTS_IDENTIFIER)) {
            this.parseEntries((List<class_2520>)compound.method_10554(NbtConstants.INGREDIENTS_IDENTIFIER, 10)).forEach(partConsumer);
        }
        if (compound.method_10545(NbtConstants.INGREDIENTS_IDENTIFIER)) {
            this.parseEntries((List<class_2520>)compound.method_10554(NbtConstants.INGREDIENTS_IDENTIFIER, 8)).forEach(partConsumer);
        }
    }

    public void parseUpgrades(Consumer<State> partConsumer, class_2487 compound) {
        if (compound.method_10545(NbtConstants.UPGRADES_IDENTIFIER)) {
            this.parseEntries((List<class_2520>)compound.method_10554(NbtConstants.UPGRADES_IDENTIFIER, 10)).forEach(partConsumer);
        }
        if (compound.method_10545(NbtConstants.UPGRADES_IDENTIFIER)) {
            this.parseEntries((List<class_2520>)compound.method_10554(NbtConstants.UPGRADES_IDENTIFIER, 8)).forEach(partConsumer);
        }
    }

    public List<State> parseEntries(List<class_2520> elements) {
        return elements.stream().map(this::parseEntry).flatMap(Optional::stream).toList();
    }

    public Optional<State> parseEntry(class_2520 element) {
        if (element.method_10711() == 8) {
            return this.supplier.find(element.method_10714());
        }
        if (element.method_10711() == 10) {
            if (element instanceof class_2487) {
                class_2487 compound = (class_2487)element;
                return this.parseCompound(compound, arg_0 -> ((StateFinder)this.supplier).find(arg_0));
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public Optional<State> parseCompound(class_2487 compound, Function<String, Optional<State>> supplier) {
        if (compound.method_10545(NbtConstants.STATE_TYPE_IDENTIFIER)) {
            if (compound.method_10558(NbtConstants.STATE_TYPE_IDENTIFIER).equals(NbtConstants.STATE_IDENTIFIER) && !compound.method_10545(NbtConstants.CONDITIONS_IDENTIFIER)) {
                return supplier.apply(compound.method_10558(NbtConstants.ID_IDENTIFIER));
            }
            if (compound.method_10558(NbtConstants.STATE_TYPE_IDENTIFIER).equals(NbtConstants.COMPOSITE_IDENTIFIER)) {
                return new CompositeParser(this.supplier).parse(compound);
            }
            if (compound.method_10558(NbtConstants.STATE_TYPE_IDENTIFIER).equals(NbtConstants.LEVELED_IDENTIFIER)) {
                return new StateParser(this.supplier).parse(compound);
            }
            if (compound.method_10545(NbtConstants.CONDITIONS_IDENTIFIER)) {
                return StateParser.STATE_PARSER.parse(compound);
            }
        }
        return this.parse(compound);
    }
}

