/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2;

import com.sigmundgranaas.forgero.core.state.Composite;
import com.sigmundgranaas.forgero.core.state.Slot;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.SlotContainer;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.CompositeParser;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.CompoundParser;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.NbtConstants;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.SlotParser;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class SlotContainerParser
implements CompoundParser<SlotContainer> {
    private final Composite defaultState;
    private final CompositeParser compositeParser;
    private final SlotParser slotParser;

    public SlotContainerParser(Composite defaultState, SlotParser slotParser, CompositeParser compositeParser) {
        this.defaultState = defaultState;
        this.compositeParser = compositeParser;
        this.slotParser = slotParser;
    }

    @Override
    public Optional<SlotContainer> parse(class_2487 compound) {
        if (compound.method_10545(NbtConstants.UPGRADES_IDENTIFIER) && this.containsAnyLegacy(compound)) {
            return this.parseLegacy(compound);
        }
        return this.parseSlots(compound.method_10554(NbtConstants.UPGRADES_IDENTIFIER, 10));
    }

    private boolean containsAnyLegacy(@Nullable class_2487 compound) {
        if (compound == null) {
            return false;
        }
        boolean isLegacy = false;
        if (compound.method_10545(NbtConstants.UPGRADES_IDENTIFIER)) {
            isLegacy = compound.method_10554(NbtConstants.UPGRADES_IDENTIFIER, 10).stream().anyMatch(this::isLegacy) || compound.method_10554(NbtConstants.UPGRADES_IDENTIFIER, 8).stream().anyMatch(this::isLegacy);
        }
        return isLegacy;
    }

    private boolean isLegacy(@Nullable class_2520 element) {
        if (element == null) {
            return true;
        }
        if (element.method_10711() == 8) {
            return true;
        }
        return element.method_10711() == 10 && ((class_2487)element).method_10545(NbtConstants.STATE_TYPE_IDENTIFIER);
    }

    public Optional<SlotContainer> parseLegacy(class_2487 upgrades) {
        ArrayList<State> states = new ArrayList<State>();
        SlotContainer slotContainer = this.defaultState.getSlotContainer().copy();
        this.compositeParser.parseUpgrades(states::add, upgrades);
        states.forEach(arg_0 -> ((SlotContainer)slotContainer).set(arg_0));
        return Optional.of(slotContainer);
    }

    public Optional<SlotContainer> parseSlots(class_2499 upgrades) {
        List slots = upgrades.stream().filter(class_2487.class::isInstance).map(class_2487.class::cast).map(this.slotParser::parse).flatMap(Optional::stream).sorted(Comparator.comparingInt(Slot::index)).collect(Collectors.toList());
        return Optional.of(new SlotContainer(slots));
    }
}

