/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2;

import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.property.attribute.Category;
import com.sigmundgranaas.forgero.core.state.Slot;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.AbstractTypedSlot;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.EmptySlot;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.FilledSlot;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.CompoundEncoder;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.StateEncoder;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;

public class SlotEncoder
implements CompoundEncoder<Slot> {
    public static final String VALUE_EMPTY_SLOT_TYPE = "forgero:empty_slot";
    public static final String VALUE_FILLED_SLOT_TYPE = "forgero:filled_slot";
    private final StateEncoder stateEncoder;

    public SlotEncoder(@NotNull StateEncoder stateEncoder) {
        this.stateEncoder = stateEncoder;
    }

    @Override
    @NotNull
    public class_2487 encode(@NotNull Slot element) {
        if (element instanceof EmptySlot) {
            EmptySlot emptySlot = (EmptySlot)element;
            return this.encodeEmptySlot(emptySlot);
        }
        if (element instanceof FilledSlot) {
            FilledSlot filledSlot = (FilledSlot)element;
            return this.encodeFilledSlot(filledSlot);
        }
        return this.stateEncoder.encode((PropertyContainer)element);
    }

    @NotNull
    private class_2487 encodeEmptySlot(@NotNull EmptySlot emptySlot) {
        class_2487 compound = this.encodeAbstractSlot((AbstractTypedSlot)emptySlot);
        compound.method_10582("codecType", VALUE_EMPTY_SLOT_TYPE);
        return compound;
    }

    @NotNull
    private class_2487 encodeFilledSlot(@NotNull FilledSlot filledSlot) {
        class_2487 compound = this.encodeAbstractSlot((AbstractTypedSlot)filledSlot);
        compound.method_10582("codecType", VALUE_FILLED_SLOT_TYPE);
        compound.method_10566("upgrade", (class_2520)this.stateEncoder.encode(filledSlot.content()));
        return compound;
    }

    @NotNull
    private class_2487 encodeAbstractSlot(@NotNull AbstractTypedSlot typedSlot) {
        class_2487 compound = new class_2487();
        compound.method_10569("index", typedSlot.index());
        compound.method_10582("description", typedSlot.description());
        compound.method_10566("categories", (class_2520)this.encodeCategories(typedSlot.category()));
        compound.method_10582("type", typedSlot.type().typeName());
        return compound;
    }

    @NotNull
    private class_2499 encodeCategories(@NotNull Set<Category> categories) {
        class_2499 list = new class_2499();
        for (Category category : categories) {
            list.add((Object)class_2519.method_23256((String)category.toString()));
        }
        return list;
    }
}

