/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2;

import com.sigmundgranaas.forgero.core.property.attribute.Category;
import com.sigmundgranaas.forgero.core.state.Slot;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.EmptySlot;
import com.sigmundgranaas.forgero.core.state.upgrade.slot.FilledSlot;
import com.sigmundgranaas.forgero.core.type.Type;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.CompoundParser;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.StateParser;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import org.jetbrains.annotations.NotNull;

public class SlotParser
implements CompoundParser<Slot> {
    private final StateParser stateParser;

    public SlotParser(StateParser stateParser) {
        this.stateParser = stateParser;
    }

    @Override
    public Optional<Slot> parse(@NotNull class_2487 compound) {
        if (!compound.method_10545("codecType")) {
            return Optional.empty();
        }
        int index = compound.method_10550("index");
        String description = compound.method_10558("description");
        Set<Category> categories = this.parseCategories(compound.method_10554("categories", 8));
        Type type = Type.of((String)compound.method_10558("type"));
        return switch (compound.method_10558("codecType")) {
            case "forgero:empty_slot" -> Optional.of(new EmptySlot(index, type, description, categories));
            case "forgero:filled_slot" -> this.stateParser.parse(compound.method_10562("upgrade")).map(upgrade -> new FilledSlot(index, type, upgrade, description, categories));
            default -> Optional.empty();
        };
    }

    private Set<Category> parseCategories(class_2499 categoryList) {
        HashSet<Category> categories = new HashSet<Category>();
        for (int i = 0; i < categoryList.size(); ++i) {
            categories.add(Category.valueOf((String)categoryList.method_10608(i)));
        }
        return categories;
    }
}

