/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2;

import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.registry.StateFinder;
import com.sigmundgranaas.forgero.core.state.ConditionedState;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.CompositeParser;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.CompoundParser;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.LeveledParser;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.NbtConstants;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.SchematicPartParser;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2487;

public class StateParser
implements CompoundParser<State> {
    private final StateFinder supplier;
    private final CompositeParser compositeParser;
    private final LeveledParser leveledParser;

    public StateParser(StateFinder supplier) {
        this.supplier = supplier;
        this.compositeParser = new CompositeParser(supplier);
        this.leveledParser = new LeveledParser(supplier);
    }

    @Override
    public Optional<State> parse(class_2487 compound) {
        if (!compound.method_10545(NbtConstants.STATE_TYPE_IDENTIFIER)) {
            return Optional.empty();
        }
        if (compound.method_10558(NbtConstants.STATE_TYPE_IDENTIFIER).equals(NbtConstants.COMPOSITE_IDENTIFIER)) {
            return this.compositeParser.parse(compound);
        }
        if (compound.method_10558(NbtConstants.STATE_TYPE_IDENTIFIER).equals(NbtConstants.LEVELED_IDENTIFIER)) {
            return this.leveledParser.parse(compound);
        }
        if (compound.method_10545(NbtConstants.CONDITIONS_IDENTIFIER)) {
            Optional state = this.supplier.find(compound.method_10558(NbtConstants.ID_IDENTIFIER));
            List<PropertyContainer> conditions = SchematicPartParser.parseConditions(compound.method_10554(NbtConstants.CONDITIONS_IDENTIFIER, 8));
            if (state.isPresent()) {
                ConditionedState conditioned = ConditionedState.of((State)((State)state.get()));
                for (PropertyContainer container : conditions) {
                    conditioned = conditioned.applyCondition(container);
                }
                return Optional.of(conditioned);
            }
        }
        return this.supplier.find(compound.method_10558(NbtConstants.ID_IDENTIFIER));
    }
}

