/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.item.tool;

import com.sigmundgranaas.forgero.core.registry.GenericRegistry;
import com.sigmundgranaas.forgero.core.registry.RankableConverter;
import com.sigmundgranaas.forgero.core.registry.Registerable;
import com.sigmundgranaas.forgero.core.state.StateProvider;
import com.sigmundgranaas.forgero.minecraft.common.item.BuildableStateConverter;
import com.sigmundgranaas.forgero.minecraft.common.item.ForgeroMaterial;
import com.sigmundgranaas.forgero.minecraft.common.item.ItemData;
import com.sigmundgranaas.forgero.minecraft.common.item.RegistryUtils;
import com.sigmundgranaas.forgero.minecraft.common.item.tool.DynamicAxeItem;
import com.sigmundgranaas.forgero.minecraft.common.item.tool.DynamicHoeItem;
import com.sigmundgranaas.forgero.minecraft.common.item.tool.DynamicPickaxeItem;
import com.sigmundgranaas.forgero.minecraft.common.item.tool.DynamicShovelItem;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import net.minecraft.class_1792;
import org.apache.commons.lang3.function.TriFunction;

public class DynamicToolItemRegistrationHandler
implements Registerable<RankableConverter<StateProvider, ItemData>> {
    private final BuildableStateConverter defaultStateConverter;

    public DynamicToolItemRegistrationHandler(BuildableStateConverter defaultStateConverter) {
        this.defaultStateConverter = defaultStateConverter;
    }

    public void register(GenericRegistry<RankableConverter<StateProvider, ItemData>> registry) {
        BuildableStateConverter base = this.defaultStateConverter.toBuilder().priority(1).build();
        registry.register("forgero:dynamic_pickaxe", (Object)base.toBuilder().matcher(RegistryUtils.typeMatcher("PICKAXE")).item(RegistryUtils.itemClassPreparer((TriFunction<StateProvider, class_1792.class_1793, RegistryUtils.DynamicToolItemSettings, class_1792>)((TriFunction)this::pickaxe))).build());
        registry.register("forgero:dynamic_axe", (Object)base.toBuilder().matcher(RegistryUtils.typeMatcher("AXE")).item(RegistryUtils.itemClassPreparer((TriFunction<StateProvider, class_1792.class_1793, RegistryUtils.DynamicToolItemSettings, class_1792>)((TriFunction)this::axe))).build());
        registry.register("forgero:dynamic_hoe", (Object)base.toBuilder().matcher(RegistryUtils.typeMatcher("HOE")).item(RegistryUtils.itemClassPreparer((TriFunction<StateProvider, class_1792.class_1793, RegistryUtils.DynamicToolItemSettings, class_1792>)((TriFunction)this::hoe))).build());
        registry.register("forgero:dynamic_shovel", (Object)base.toBuilder().matcher(RegistryUtils.typeMatcher("SHOVEL")).item(RegistryUtils.itemClassPreparer((TriFunction<StateProvider, class_1792.class_1793, RegistryUtils.DynamicToolItemSettings, class_1792>)((TriFunction)this::shovel))).build());
    }

    private class_1792 pickaxe(StateProvider provider, class_1792.class_1793 settings, RegistryUtils.DynamicToolItemSettings params) {
        return new DynamicPickaxeItem(new ForgeroMaterial(provider, params.ingredient(), StateService.INSTANCE), params.attackDamage(), params.attackSpeed(), settings, provider);
    }

    private class_1792 hoe(StateProvider provider, class_1792.class_1793 settings, RegistryUtils.DynamicToolItemSettings params) {
        return new DynamicHoeItem(new ForgeroMaterial(provider, params.ingredient(), StateService.INSTANCE), params.attackDamage(), params.attackSpeed(), settings, provider);
    }

    private class_1792 shovel(StateProvider provider, class_1792.class_1793 settings, RegistryUtils.DynamicToolItemSettings params) {
        return new DynamicShovelItem(new ForgeroMaterial(provider, params.ingredient(), StateService.INSTANCE), params.attackDamage(), params.attackSpeed(), settings, provider);
    }

    private class_1792 axe(StateProvider provider, class_1792.class_1793 settings, RegistryUtils.DynamicToolItemSettings params) {
        return new DynamicAxeItem(new ForgeroMaterial(provider, params.ingredient(), StateService.INSTANCE), params.attackDamage(), params.attackSpeed(), settings, provider);
    }
}

