/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.loot;

import com.sigmundgranaas.forgero.core.customdata.VisitorHelper;
import com.sigmundgranaas.forgero.core.customdata.handler.LootVisitor;
import com.sigmundgranaas.forgero.core.resource.data.v2.data.LootEntryData;
import com.sigmundgranaas.forgero.minecraft.common.loot.LootEntry;
import com.sigmundgranaas.forgero.minecraft.common.loot.StateFilter;
import com.sigmundgranaas.forgero.minecraft.common.loot.function.ConditionFunction;
import com.sigmundgranaas.forgero.minecraft.common.loot.function.GemLevelFunction;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_117;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_40;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_77;
import net.minecraft.class_79;

public class SingleLootEntry
implements LootEntry {
    private List<class_2960> target;
    private Supplier<List<class_1792>> filter;
    private int weight;
    private int rolls;
    private float chance;

    public static LootEntry of(LootEntryData data) {
        StateFilter filter = StateFilter.builder().types(data.types()).lowerRarity(data.lower_rarity_limit()).upperRarity(data.upper_rarity_limit()).build();
        return SingleLootEntry.builder().chance(data.chance()).rolls(data.rolls()).filter(filter::filter).target(data.targets().stream().map(class_2960::new).toList()).weight(1).build();
    }

    @Override
    public void apply(class_52.class_53 builder) {
        class_55.class_56 pool = class_55.method_347().method_352((class_5658)class_40.method_273((int)this.rolls, (float)this.chance));
        this.filter.get().stream().filter(this::filter).forEach(item -> pool.method_351((class_79.class_80)class_77.method_411((class_1935)item).method_438((class_117.class_118)new GemLevelFunction.Builder()).method_438((class_117.class_118)new ConditionFunction.Builder()).method_437(1)));
        builder.method_336(pool);
    }

    @Override
    public boolean matches(class_2960 id) {
        return this.target.stream().anyMatch(target -> target.equals((Object)id));
    }

    private boolean filter(class_1792 item) {
        Optional customLootData = VisitorHelper.of((Object)item, LootVisitor::new);
        return !customLootData.isPresent() || !((LootVisitor.CustomLootData)customLootData.get()).isExcluded(this.target.stream().map(class_2960::toString).toList());
    }

    private static int $default$rolls() {
        return 1;
    }

    private static float $default$chance() {
        return 1.0f;
    }

    SingleLootEntry(List<class_2960> target, Supplier<List<class_1792>> filter, int weight, int rolls, float chance) {
        this.target = target;
        this.filter = filter;
        this.weight = weight;
        this.rolls = rolls;
        this.chance = chance;
    }

    public static SingleLootEntryBuilder builder() {
        return new SingleLootEntryBuilder();
    }

    public List<class_2960> getTarget() {
        return this.target;
    }

    public Supplier<List<class_1792>> getFilter() {
        return this.filter;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getRolls() {
        return this.rolls;
    }

    public float getChance() {
        return this.chance;
    }

    public void setTarget(List<class_2960> target) {
        this.target = target;
    }

    public void setFilter(Supplier<List<class_1792>> filter) {
        this.filter = filter;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public void setRolls(int rolls) {
        this.rolls = rolls;
    }

    public void setChance(float chance) {
        this.chance = chance;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SingleLootEntry)) {
            return false;
        }
        SingleLootEntry other = (SingleLootEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWeight() != other.getWeight()) {
            return false;
        }
        if (this.getRolls() != other.getRolls()) {
            return false;
        }
        if (Float.compare(this.getChance(), other.getChance()) != 0) {
            return false;
        }
        List<class_2960> this$target = this.getTarget();
        List<class_2960> other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        Supplier<List<class_1792>> this$filter = this.getFilter();
        Supplier<List<class_1792>> other$filter = other.getFilter();
        return !(this$filter == null ? other$filter != null : !this$filter.equals(other$filter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SingleLootEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWeight();
        result = result * 59 + this.getRolls();
        result = result * 59 + Float.floatToIntBits(this.getChance());
        List<class_2960> $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        Supplier<List<class_1792>> $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        return result;
    }

    public String toString() {
        return "SingleLootEntry(target=" + this.getTarget() + ", filter=" + this.getFilter() + ", weight=" + this.getWeight() + ", rolls=" + this.getRolls() + ", chance=" + this.getChance() + ")";
    }

    public static class SingleLootEntryBuilder {
        private List<class_2960> target;
        private Supplier<List<class_1792>> filter;
        private int weight;
        private boolean rolls$set;
        private int rolls$value;
        private boolean chance$set;
        private float chance$value;

        SingleLootEntryBuilder() {
        }

        public SingleLootEntryBuilder target(List<class_2960> target) {
            this.target = target;
            return this;
        }

        public SingleLootEntryBuilder filter(Supplier<List<class_1792>> filter) {
            this.filter = filter;
            return this;
        }

        public SingleLootEntryBuilder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public SingleLootEntryBuilder rolls(int rolls) {
            this.rolls$value = rolls;
            this.rolls$set = true;
            return this;
        }

        public SingleLootEntryBuilder chance(float chance) {
            this.chance$value = chance;
            this.chance$set = true;
            return this;
        }

        public SingleLootEntry build() {
            int rolls$value = this.rolls$value;
            if (!this.rolls$set) {
                rolls$value = SingleLootEntry.$default$rolls();
            }
            float chance$value = this.chance$value;
            if (!this.chance$set) {
                chance$value = SingleLootEntry.$default$chance();
            }
            return new SingleLootEntry(this.target, this.filter, this.weight, rolls$value, chance$value);
        }

        public String toString() {
            return "SingleLootEntry.SingleLootEntryBuilder(target=" + this.target + ", filter=" + this.filter + ", weight=" + this.weight + ", rolls$value=" + this.rolls$value + ", chance$value=" + this.chance$value + ")";
        }
    }
}

