/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.loot;

import com.google.common.collect.ImmutableList;
import com.sigmundgranaas.forgero.core.ForgeroStateRegistry;
import com.sigmundgranaas.forgero.core.state.Identifiable;
import com.sigmundgranaas.forgero.core.state.State;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class StateFilter {
    private int upperRarity;
    private int lowerRarity;
    private List<String> types;
    private List<String> ids;
    private List<String> exclusion;
    private List<String> include;

    public static StateFilterBuilder builder() {
        return new StateFilterBuilder();
    }

    public List<class_1792> filter() {
        ArrayList states = new ArrayList();
        this.types.stream().map(type -> ForgeroStateRegistry.TREE.find(type).map(node -> node.getResources(State.class)).orElse(ImmutableList.builder().build())).flatMap(Collection::stream).filter(this::filter).forEach(states::add);
        this.ids.stream().map(id -> ForgeroStateRegistry.stateFinder().find(id)).flatMap(Optional::stream).filter(this::filter).forEach(states::add);
        return states.stream().map(Identifiable::identifier).map(id -> (class_1792)class_7923.field_41178.method_10223(new class_2960(id))).toList();
    }

    private boolean filter(State state) {
        if (state.stream().applyAttribute("RARITY") < (float)this.lowerRarity) {
            return false;
        }
        if (state.stream().applyAttribute("RARITY") > (float)this.upperRarity) {
            return false;
        }
        if (this.exclusion.stream().anyMatch(exclusion -> this.stringMatch((String)exclusion, state))) {
            return false;
        }
        return this.include.size() == 0 || this.include.stream().anyMatch(include -> this.stringMatch((String)include, state));
    }

    private boolean stringMatch(String match, State state) {
        if (state.identifier().contains(match)) {
            return true;
        }
        return state.type().typeName().contains(match);
    }

    private static int $default$upperRarity() {
        return 0;
    }

    private static int $default$lowerRarity() {
        return 0;
    }

    private static List<String> $default$types() {
        return new ArrayList<String>();
    }

    private static List<String> $default$ids() {
        return new ArrayList<String>();
    }

    private static List<String> $default$exclusion() {
        return new ArrayList<String>();
    }

    private static List<String> $default$include() {
        return new ArrayList<String>();
    }

    StateFilter(int upperRarity, int lowerRarity, List<String> types, List<String> ids, List<String> exclusion, List<String> include) {
        this.upperRarity = upperRarity;
        this.lowerRarity = lowerRarity;
        this.types = types;
        this.ids = ids;
        this.exclusion = exclusion;
        this.include = include;
    }

    public StateFilterBuilder toBuilder() {
        return new StateFilterBuilder().upperRarity(this.upperRarity).lowerRarity(this.lowerRarity).types(this.types).ids(this.ids).exclusion(this.exclusion).include(this.include);
    }

    public int getUpperRarity() {
        return this.upperRarity;
    }

    public int getLowerRarity() {
        return this.lowerRarity;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public List<String> getExclusion() {
        return this.exclusion;
    }

    public List<String> getInclude() {
        return this.include;
    }

    public void setUpperRarity(int upperRarity) {
        this.upperRarity = upperRarity;
    }

    public void setLowerRarity(int lowerRarity) {
        this.lowerRarity = lowerRarity;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public void setIds(List<String> ids) {
        this.ids = ids;
    }

    public void setExclusion(List<String> exclusion) {
        this.exclusion = exclusion;
    }

    public void setInclude(List<String> include) {
        this.include = include;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StateFilter)) {
            return false;
        }
        StateFilter other = (StateFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUpperRarity() != other.getUpperRarity()) {
            return false;
        }
        if (this.getLowerRarity() != other.getLowerRarity()) {
            return false;
        }
        List<String> this$types = this.getTypes();
        List<String> other$types = other.getTypes();
        if (this$types == null ? other$types != null : !((Object)this$types).equals(other$types)) {
            return false;
        }
        List<String> this$ids = this.getIds();
        List<String> other$ids = other.getIds();
        if (this$ids == null ? other$ids != null : !((Object)this$ids).equals(other$ids)) {
            return false;
        }
        List<String> this$exclusion = this.getExclusion();
        List<String> other$exclusion = other.getExclusion();
        if (this$exclusion == null ? other$exclusion != null : !((Object)this$exclusion).equals(other$exclusion)) {
            return false;
        }
        List<String> this$include = this.getInclude();
        List<String> other$include = other.getInclude();
        return !(this$include == null ? other$include != null : !((Object)this$include).equals(other$include));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StateFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getUpperRarity();
        result = result * 59 + this.getLowerRarity();
        List<String> $types = this.getTypes();
        result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
        List<String> $ids = this.getIds();
        result = result * 59 + ($ids == null ? 43 : ((Object)$ids).hashCode());
        List<String> $exclusion = this.getExclusion();
        result = result * 59 + ($exclusion == null ? 43 : ((Object)$exclusion).hashCode());
        List<String> $include = this.getInclude();
        result = result * 59 + ($include == null ? 43 : ((Object)$include).hashCode());
        return result;
    }

    public String toString() {
        return "StateFilter(upperRarity=" + this.getUpperRarity() + ", lowerRarity=" + this.getLowerRarity() + ", types=" + this.getTypes() + ", ids=" + this.getIds() + ", exclusion=" + this.getExclusion() + ", include=" + this.getInclude() + ")";
    }

    public static class StateFilterBuilder {
        private boolean upperRarity$set;
        private int upperRarity$value;
        private boolean lowerRarity$set;
        private int lowerRarity$value;
        private boolean types$set;
        private List<String> types$value;
        private boolean ids$set;
        private List<String> ids$value;
        private boolean exclusion$set;
        private List<String> exclusion$value;
        private boolean include$set;
        private List<String> include$value;

        StateFilterBuilder() {
        }

        public StateFilterBuilder upperRarity(int upperRarity) {
            this.upperRarity$value = upperRarity;
            this.upperRarity$set = true;
            return this;
        }

        public StateFilterBuilder lowerRarity(int lowerRarity) {
            this.lowerRarity$value = lowerRarity;
            this.lowerRarity$set = true;
            return this;
        }

        public StateFilterBuilder types(List<String> types) {
            this.types$value = types;
            this.types$set = true;
            return this;
        }

        public StateFilterBuilder ids(List<String> ids) {
            this.ids$value = ids;
            this.ids$set = true;
            return this;
        }

        public StateFilterBuilder exclusion(List<String> exclusion) {
            this.exclusion$value = exclusion;
            this.exclusion$set = true;
            return this;
        }

        public StateFilterBuilder include(List<String> include) {
            this.include$value = include;
            this.include$set = true;
            return this;
        }

        public StateFilter build() {
            int upperRarity$value = this.upperRarity$value;
            if (!this.upperRarity$set) {
                upperRarity$value = StateFilter.$default$upperRarity();
            }
            int lowerRarity$value = this.lowerRarity$value;
            if (!this.lowerRarity$set) {
                lowerRarity$value = StateFilter.$default$lowerRarity();
            }
            List<String> types$value = this.types$value;
            if (!this.types$set) {
                types$value = StateFilter.$default$types();
            }
            List<String> ids$value = this.ids$value;
            if (!this.ids$set) {
                ids$value = StateFilter.$default$ids();
            }
            List<String> exclusion$value = this.exclusion$value;
            if (!this.exclusion$set) {
                exclusion$value = StateFilter.$default$exclusion();
            }
            List<String> include$value = this.include$value;
            if (!this.include$set) {
                include$value = StateFilter.$default$include();
            }
            return new StateFilter(upperRarity$value, lowerRarity$value, types$value, ids$value, exclusion$value, include$value);
        }

        public String toString() {
            return "StateFilter.StateFilterBuilder(upperRarity$value=" + this.upperRarity$value + ", lowerRarity$value=" + this.lowerRarity$value + ", types$value=" + this.types$value + ", ids$value=" + this.ids$value + ", exclusion$value=" + this.exclusion$value + ", include$value=" + this.include$value + ")";
        }
    }
}

