/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.loot.function;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sigmundgranaas.forgero.core.condition.Conditional;
import com.sigmundgranaas.forgero.core.condition.Conditions;
import com.sigmundgranaas.forgero.core.condition.LootCondition;
import com.sigmundgranaas.forgero.core.condition.NamedCondition;
import com.sigmundgranaas.forgero.core.property.PropertyContainer;
import com.sigmundgranaas.forgero.core.state.State;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.CompoundEncoder;
import com.sigmundgranaas.forgero.minecraft.common.item.nbt.v2.NbtConstants;
import com.sigmundgranaas.forgero.minecraft.common.registry.registrar.LootFunctionRegistrar;
import com.sigmundgranaas.forgero.minecraft.common.service.StateService;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_117;
import net.minecraft.class_120;
import net.minecraft.class_1799;
import net.minecraft.class_2520;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;

public class ConditionFunction
extends class_120 {
    public static Codec<ConditionFunction> CODEC = RecordCodecBuilder.create(instance -> ConditionFunction.method_53344((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, ConditionFunction::of));
    private final StateService service;

    protected ConditionFunction(List<class_5341> conditions, StateService service) {
        super(conditions);
        this.service = service;
    }

    public static ConditionFunction of(List<class_5341> conditions) {
        return new ConditionFunction(conditions, StateService.INSTANCE);
    }

    protected class_1799 method_522(class_1799 stack, class_47 context) {
        State state;
        Optional<State> converted = this.service.convert(stack);
        if (converted.isPresent() && (state = converted.get()) instanceof Conditional) {
            Conditional conditional = (Conditional)state;
            List<LootCondition> conditions = Conditions.INSTANCE.all().stream().filter(condition -> condition.isApplicable(conditional)).filter(condition -> context.method_294().method_43058() < (double)(condition.getChance() + context.method_302())).sorted(Comparator.comparing(LootCondition::getPriority)).toList();
            Conditional conditioned = conditional;
            for (NamedCondition namedCondition : conditions) {
                conditioned = (Conditional)conditioned.applyCondition((PropertyContainer)namedCondition);
            }
            if (conditioned instanceof PropertyContainer) {
                PropertyContainer container = (PropertyContainer)conditioned;
                if (!conditions.isEmpty()) {
                    stack.method_7948().method_10566(NbtConstants.FORGERO_IDENTIFIER, (class_2520)CompoundEncoder.ENCODER.encode(container));
                }
            }
        }
        return stack;
    }

    public class_5339 method_29321() {
        return LootFunctionRegistrar.CONDITION_LOOT_FUNCTION_TYPE;
    }

    public static class Builder
    extends class_120.class_121<Builder> {
        protected Builder getThisBuilder() {
            return this;
        }

        public class_117 method_515() {
            return new ConditionFunction(this.method_526(), StateService.INSTANCE);
        }
    }
}

