/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.match.predicate;

import com.google.gson.JsonElement;
import com.sigmundgranaas.forgero.core.model.match.builders.ElementParser;
import com.sigmundgranaas.forgero.core.model.match.builders.PredicateBuilder;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.match.MinecraftContextKeys;
import java.util.Optional;

public record DamagePercentagePredicate(float percentage) implements Matchable
{
    public static String ID = "forgero:damage_percentage";

    public boolean isDynamic() {
        return true;
    }

    public boolean test(Matchable match, MatchContext context) {
        Optional stackOpt = context.get(MinecraftContextKeys.STACK);
        if (this.percentage > 1.0f) {
            return stackOpt.filter(stack -> (float)stack.method_7919() / (float)stack.method_7936() * 100.0f >= this.percentage).isPresent();
        }
        return stackOpt.filter(stack -> (float)stack.method_7919() / (float)stack.method_7936() >= this.percentage).isPresent();
    }

    public static class DamagePercentagePredicateBuilder
    implements PredicateBuilder {
        public Optional<Matchable> create(JsonElement element) {
            return ElementParser.fromIdentifiedElement((JsonElement)element, (String)ID).map(jsonObject -> new DamagePercentagePredicate(jsonObject.get("percentage").getAsInt()));
        }
    }
}

