/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.match.predicate;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.sigmundgranaas.forgero.core.model.match.builders.ElementParser;
import com.sigmundgranaas.forgero.core.model.match.builders.PredicateBuilder;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.match.MinecraftContextKeys;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public record RandomPredicate(float value, int worldTimeQuantization, List<SeedSource> seedSources) implements Matchable
{
    public static String ID = "forgero:random";

    public boolean test(Matchable match, MatchContext context) {
        long seed = this.generateSeed(context);
        Random random = new Random(seed);
        return random.nextFloat() < this.value;
    }

    private long generateSeed(MatchContext context) {
        return this.seedSources.stream().mapToLong(source -> switch (source) {
            default -> throw new IncompatibleClassChangeError();
            case SeedSource.BLOCK_POS -> context.get(MinecraftContextKeys.BLOCK_TARGET).map(class_2338::method_10063).orElse(0L);
            case SeedSource.TARGET_ENTITY -> context.get(MinecraftContextKeys.ENTITY_TARGET).map(class_1297::method_5628).orElse(0).intValue();
            case SeedSource.SOURCE_ENTITY -> context.get(MinecraftContextKeys.ENTITY).map(class_1297::method_5628).orElse(0).intValue();
            case SeedSource.WORLD_TIME -> this.quantizeWorldTime(context.get(MinecraftContextKeys.WORLD).map(class_1937::method_8510).orElse(0L), this.worldTimeQuantization);
            case SeedSource.NONE -> 0L;
        }).reduce(0L, (a, b) -> a ^ b);
    }

    private long quantizeWorldTime(long worldTime, long quantizationInterval) {
        return quantizationInterval > 0L ? worldTime / quantizationInterval : worldTime;
    }

    public boolean isDynamic() {
        return true;
    }

    public static enum SeedSource {
        BLOCK_POS,
        TARGET_ENTITY,
        SOURCE_ENTITY,
        WORLD_TIME,
        NONE;

    }

    public static class RandomPredicatePredicateBuilder
    implements PredicateBuilder {
        public Optional<Matchable> create(JsonElement element) {
            return ElementParser.fromIdentifiedElement((JsonElement)element, (String)ID).map(jsonObject -> {
                float value = jsonObject.get("value").getAsFloat();
                int worldTimeQuantization = jsonObject.has("worldTimeQuantization") ? jsonObject.get("worldTimeQuantization").getAsInt() : 0;
                List<SeedSource> seedSources = this.parseSeedSources(jsonObject.getAsJsonArray("seed"));
                return new RandomPredicate(value, worldTimeQuantization, seedSources);
            });
        }

        private List<SeedSource> parseSeedSources(JsonArray jsonArray) {
            return StreamSupport.stream(jsonArray.spliterator(), false).map(JsonElement::getAsString).map(String::toUpperCase).map(SeedSource::valueOf).collect(Collectors.toList());
        }
    }
}

