/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.predicate;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class AbstractMapCodec
extends MapCodec<Map.Entry<String, Object>> {
    private final Map<String, Codec<Object>> map = new HashMap<String, Codec<Object>>();

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return null;
    }

    public <T> RecordBuilder<T> encode(Map.Entry<String, Object> entry, DynamicOps<T> ops, RecordBuilder<T> recordBuilder) {
        String key = entry.getKey();
        Object value = entry.getValue();
        Codec<Object> valueCodec = this.map.get(key);
        if (valueCodec == null) {
            recordBuilder.add(ops.createString(key), DataResult.error(() -> "No codec registered for key: " + key));
        } else {
            DataResult encodedValue = valueCodec.encodeStart(ops, value);
            encodedValue.resultOrPartial(System.err::println).ifPresent(encoded -> recordBuilder.add(ops.createString(key), encoded));
        }
        return recordBuilder;
    }

    public <T> DataResult<Map.Entry<String, Object>> decode(DynamicOps<T> ops, MapLike<T> input) {
        if (input.entries().toList().size() != 1) {
            return DataResult.error(() -> "Expected a single entry for map codec");
        }
        Object key = ((Pair)input.entries().findFirst().get()).getFirst();
        if (key == null) {
            return DataResult.error(() -> "Missing key for map entry");
        }
        DataResult keyResult = ops.getStringValue(key);
        if (keyResult.error().isPresent()) {
            return DataResult.error(() -> "Key is not a string: " + ((DataResult.PartialResult)keyResult.error().get()).message());
        }
        String keyString = keyResult.result().orElse(null);
        Codec<Object> valueCodec = this.map.get(keyString);
        if (valueCodec == null) {
            return DataResult.error(() -> "No codec registered for key: " + keyString);
        }
        Object value = input.get(key);
        return valueCodec.parse(ops, value).map(v -> Map.entry(keyString, v));
    }
}

