/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.predicate;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.sigmundgranaas.forgero.minecraft.common.predicate.GroupEntry;
import com.sigmundgranaas.forgero.minecraft.common.predicate.KeyPair;
import com.sigmundgranaas.forgero.minecraft.common.predicate.SpecificationRegistry;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SpecificationBackedPredicateCodec<T>
extends MapCodec<GroupEntry<KeyPair<Predicate<T>>>> {
    private final String key;
    private final SpecificationRegistry<Codec<KeyPair<Predicate<T>>>> codecs;

    public SpecificationBackedPredicateCodec(String key, SpecificationRegistry<Codec<KeyPair<Predicate<T>>>> codec) {
        this.key = key;
        this.codecs = codec;
    }

    public <R> Stream<R> keys(DynamicOps<R> ops) {
        return this.codecs.keySet().stream().map(arg_0 -> ops.createString(arg_0));
    }

    public <R> RecordBuilder<R> encode(GroupEntry<KeyPair<Predicate<T>>> input, DynamicOps<R> ops, RecordBuilder<R> prefix) {
        RecordBuilder temp = prefix;
        for (KeyPair<Predicate<T>> element : input.entries()) {
            Optional res;
            Optional<Codec> codec = this.codecs.apply(element.key()).map(KeyPair::value);
            if (!codec.isPresent() || !(res = codec.get().encodeStart(ops, element).result()).isPresent()) continue;
            temp = temp.add(ops.createString(element.key()), res.get());
        }
        temp = prefix.add("type", ops.createString(this.key));
        return temp;
    }

    public <R> DataResult<GroupEntry<KeyPair<Predicate<T>>>> decode(DynamicOps<R> ops, MapLike<R> input) {
        String type = ops.getStringValue(input.get("type")).result().orElse("");
        if (!type.equals(this.key)) {
            return DataResult.error(() -> "Incorrect type");
        }
        List elements = input.entries().map(entry -> {
            String key = ops.getStringValue(entry.getFirst()).result().orElse("");
            return this.codecs.apply(key).map(KeyPair::value).map(codec -> codec.parse(ops, entry.getSecond())).flatMap(DataResult::result);
        }).flatMap(Optional::stream).collect(Collectors.toList());
        return DataResult.success(new GroupEntry(this.key, elements));
    }
}

