/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.predicate.block;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public record BlockPredicate(List<class_2248> blocks) implements Predicate<class_2248>
{
    public static final Codec<BlockPredicate> CODEC = Codec.either((Codec)class_2960.field_25139, (Codec)Codec.list((Codec)class_2960.field_25139)).xmap(BlockPredicate::fromEither, BlockPredicate::toEither);

    @Override
    public boolean test(class_2248 block) {
        return !this.blocks.isEmpty() && this.blocks.contains(block);
    }

    private static BlockPredicate fromEither(Either<class_2960, List<class_2960>> either) {
        return new BlockPredicate((List)either.map(id -> Collections.singletonList(BlockPredicate.identifierToBlock(id)), BlockPredicate::identifiersToBlocks));
    }

    private static Either<class_2960, List<class_2960>> toEither(BlockPredicate predicate) {
        List<class_2960> ids = BlockPredicate.blocksToIdentifiers(predicate.blocks);
        return ids.size() == 1 ? Either.left((Object)ids.get(0)) : Either.right(ids);
    }

    private static class_2248 identifierToBlock(class_2960 id) {
        return (class_2248)class_7923.field_41175.method_10223(id);
    }

    private static class_2960 blockToIdentifier(class_2248 block) {
        return class_7923.field_41175.method_10221((Object)block);
    }

    private static List<class_2248> identifiersToBlocks(List<class_2960> identifiers) {
        return identifiers.stream().map(BlockPredicate::identifierToBlock).toList();
    }

    private static List<class_2960> blocksToIdentifiers(List<class_2248> blocks) {
        return blocks.stream().map(BlockPredicate::blockToIdentifier).toList();
    }
}

