/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.predicate.block;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.sigmundgranaas.forgero.core.util.match.MatchContext;
import com.sigmundgranaas.forgero.core.util.match.Matchable;
import com.sigmundgranaas.forgero.minecraft.common.api.v0.predicate.Registries;
import com.sigmundgranaas.forgero.minecraft.common.handler.blockbreak.filter.BlockFilter;
import com.sigmundgranaas.forgero.minecraft.common.predicate.GroupEntry;
import com.sigmundgranaas.forgero.minecraft.common.predicate.KeyPair;
import com.sigmundgranaas.forgero.minecraft.common.predicate.SpecificationBackedPredicateCodec;
import com.sigmundgranaas.forgero.minecraft.common.predicate.block.WorldBlockPair;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_4538;

public class BlockPredicateMatcher
implements Predicate<WorldBlockPair>,
Matchable,
BlockFilter {
    private final GroupEntry<KeyPair<Predicate<WorldBlockPair>>> entry;
    public static final String TYPE = "minecraft:block";
    public static final SpecificationBackedPredicateCodec<WorldBlockPair> BLOCK_CODEC = new SpecificationBackedPredicateCodec("minecraft:block", Registries.BLOCK_CODEC_REGISTRY);
    public static final Codec<BlockPredicateMatcher> CODEC = new MapCodec.MapCodecCodec(BLOCK_CODEC.xmap(BlockPredicateMatcher::new, blockPredicate -> blockPredicate.entry));

    public BlockPredicateMatcher(GroupEntry<KeyPair<Predicate<WorldBlockPair>>> entry) {
        this.entry = entry;
    }

    @Override
    public boolean test(WorldBlockPair pair) {
        if (this.entry.entries().isEmpty()) {
            return false;
        }
        return this.entry.entries().stream().map(KeyPair::value).allMatch(spec -> spec.test(pair));
    }

    public boolean test(Matchable match, MatchContext context) {
        return WorldBlockPair.of(context).map(this::test).orElse(false);
    }

    @Override
    public boolean filter(class_1297 entity, class_2338 currentPos, class_2338 root) {
        return this.test(new WorldBlockPair((class_4538)entity.method_37908(), currentPos));
    }
}

