/*
 * Decompiled with CFR 0.152.
 */
package com.sigmundgranaas.forgero.minecraft.common.predicate.block;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public record TagPredicate(List<class_6862<class_2248>> tags) implements Predicate<class_2680>
{
    public static final Codec<TagPredicate> CODEC = Codec.either((Codec)class_2960.field_25139, (Codec)Codec.list((Codec)class_2960.field_25139)).xmap(TagPredicate::fromEither, TagPredicate::toEither);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean test(class_2680 blockState) {
        if (this.tags.isEmpty()) return false;
        if (!this.tags.stream().anyMatch(arg_0 -> ((class_2680)blockState).method_26164(arg_0))) return false;
        return true;
    }

    private static TagPredicate fromEither(Either<class_2960, List<class_2960>> either) {
        return new TagPredicate((List)either.map(id -> Collections.singletonList(TagPredicate.identifierToTag(id)), TagPredicate::identifiersToTags));
    }

    private static Either<class_2960, List<class_2960>> toEither(TagPredicate predicate) {
        List<class_2960> ids = TagPredicate.tagsToIdentifiers(predicate.tags);
        return ids.size() == 1 ? Either.left((Object)ids.get(0)) : Either.right(ids);
    }

    private static class_6862<class_2248> identifierToTag(class_2960 id) {
        return class_6862.method_40092((class_5321)class_7923.field_41175.method_30517(), (class_2960)id);
    }

    private static class_2960 tagToIdentifier(class_6862<class_2248> tag) {
        return tag.comp_327();
    }

    private static List<class_6862<class_2248>> identifiersToTags(List<class_2960> identifiers) {
        return identifiers.stream().map(TagPredicate::identifierToTag).toList();
    }

    private static List<class_2960> tagsToIdentifiers(List<class_6862<class_2248>> blocks) {
        return blocks.stream().map(TagPredicate::tagToIdentifier).toList();
    }
}

